// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __CONTEXT_REGISTRY_H
#define __CONTEXT_REGISTRY_H

#include <dingus/utils/Singleton.h>

namespace unco {


class CContextRegistry : public dingus::CSingleton<CContextRegistry> {
public:
	bool isContext( const std::string& name ) const;
	void* getContext( const std::string& name ) const;
	void setContext( const std::string& name, void* ctx );

private:
	static CContextRegistry* createInstance() { return new CContextRegistry(); }
	static void deleteInstance( CContextRegistry& instance ) { delete &instance; }
	friend dingus::CSingleton<CContextRegistry>;
	CContextRegistry() { };

private:
	typedef std::map<std::string,void*>	TContextsMap;

private:
	TContextsMap		mContexts;
};


}; // namespace

#endif
