// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __CONTEXTS_H
#define __CONTEXTS_H

#include "ContextRegistry.h"

namespace dingus {
	class CRenderContext;
	class CVisibilityContext;
	class CInputContext;
	class CPortalContext;
	class CCollisionContext;
	class CPhysicsContext;
	class CDynamicVBManager;
};


namespace unco {


// --------------------------------------------------------------------------
//  standard context names

const std::string CTX_RENDER	= "render";
const std::string CTX_VIS		= "vis";
const std::string CTX_COLLISION	= "coll";
const std::string CTX_PHYSICS	= "phys";
const std::string CTX_INPUT		= "input";
const std::string CTX_PORTAL	= "portal";
const std::string CTX_DYNAVB	= "dynavb";


// --------------------------------------------------------------------------
//  standard contexts helper

class CContexts {
public:
	static dingus::CRenderContext& getRenderCtx();
	static dingus::CVisibilityContext& getVisCtx();
	static dingus::CInputContext& getInputCtx();
	static dingus::CPortalContext& getPortalCtx();
	static dingus::CCollisionContext& getCollisionCtx();
	static dingus::CPhysicsContext& getPhysicsCtx();
	static dingus::CDynamicVBManager& getDynamicVBManager();
};



// --------------------------------------------------------------------------
//  hacky-wacky macro :)

#define IMPL_GET_CTX(method,name,clazz) \
inline clazz& CContexts::method() { \
return *reinterpret_cast<clazz*>( CContextRegistry::getInstance().getContext(name) ); \
}


IMPL_GET_CTX(getRenderCtx,CTX_RENDER,dingus::CRenderContext);
IMPL_GET_CTX(getVisCtx,CTX_VIS,dingus::CVisibilityContext);
IMPL_GET_CTX(getInputCtx,CTX_INPUT,dingus::CInputContext);
IMPL_GET_CTX(getPortalCtx,CTX_PORTAL,dingus::CPortalContext);
IMPL_GET_CTX(getCollisionCtx,CTX_COLLISION,dingus::CCollisionContext);
IMPL_GET_CTX(getPhysicsCtx,CTX_PHYSICS,dingus::CPhysicsContext);
IMPL_GET_CTX(getDynamicVBManager,CTX_DYNAVB,dingus::CDynamicVBManager);


}; // namespace

#endif
