// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __I_ENGINE_APPLICATION_H
#define __I_ENGINE_APPLICATION_H

#include <dingus/pipeline/PipelineStage.h>


namespace unco {



struct SStartupParams {
	const char* windowTitle;
	const char* dataPath;
	int		windowWidth;
	int		windowHeight;
	int		minColorBits;
	int		minAlphaBits;
	int		minZBits;
	int		minStencilBits;
	bool	usesZBuffer;
	bool	startFullscreen;
	bool	showCursorFullscreen;
};



class IEngineApplication : public dingus::IPipelineStage {
public:
	virtual ~IEngineApplication() = 0 { }

	virtual SStartupParams getStartupParams() = 0;
	virtual bool checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format ) = 0;

	virtual void initialize() = 0;
	virtual void shutdown() = 0;

	virtual void onBeginPerform() = 0;
	virtual void onEndPerform() = 0;

	// IPipelineStage
	virtual void perform() = 0;
};



}; // namespace

#endif
