#ifndef __COLLIDE_PART_H
#define __COLLIDE_PART_H

namespace dingus {
	class CCollidableContainer;
};


class ICollidePartDesc : public boost::noncopyable {
public:
	virtual ~ICollidePartDesc() = 0 { }
	virtual unco::CAbstractColComponent* createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const = 0;
	virtual void calcMass( dMass& mass, double density ) const = 0;
};


class CBoxCollidePartDesc : public ICollidePartDesc {
public:
	CBoxCollidePartDesc( const SVector3& size, const SVector3& pos, const SQuaternion& rot );
	virtual unco::CAbstractColComponent* createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const;
	virtual void calcMass( dMass& mass, double density ) const;
private:
	SVector3	mSize;
	SVector3	mPos;
	SQuaternion	mRot;
};


class CSphereCollidePartDesc : public ICollidePartDesc {
public:
	CSphereCollidePartDesc( float size, const SVector3& pos );
	virtual unco::CAbstractColComponent* createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const;
	virtual void calcMass( dMass& mass, double density ) const;
private:
	float		mSize;
	SVector3	mPos;
};

class CMeshCollidePartDesc : public ICollidePartDesc {
public:
	CMeshCollidePartDesc( dingus::CCollisionMesh& mesh, const SVector3& pos, const SQuaternion& rot );
	virtual unco::CAbstractColComponent* createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const;
	virtual void calcMass( dMass& mass, double density ) const;
private:
	dingus::CCollisionMesh*	mMesh;
	SVector3	mPos;
	SQuaternion	mRot;
};


#endif
