#ifndef __ENTITY_CLASS_H
#define __ENTITY_CLASS_H

#include "CollidePart.h"

namespace dingus {
	class CCollidableContainer;
};
// --------------------------------------------------------------------------

struct SMeshPart {
public:
	SMeshPart();
	SMeshPart( SMeshPart const& rhs );
	SMeshPart const& operator=( SMeshPart const& rhs );

public:
	dingus::CResourceId		textureID;
	dingus::CResourceId		fxID;
	int						renderLayer;
};


// --------------------------------------------------------------------------

class CEntityClass : public boost::noncopyable {
public:
	typedef std::vector<SMeshPart>			TPartVector;
	typedef std::vector<ICollidePartDesc*>	TCollidePartsVector;

public:
	CEntityClass( const std::string& name );

	std::string const& getName() const { return mName; }

	void	addPart( const SMeshPart& part ) { mParts.push_back(part); }
	TPartVector const& getParts() const { return mParts; }

	void	addColPart( ICollidePartDesc& part ) { mColParts.push_back(&part); }
	dingus::CCollidableContainer& createColComponents( unco::CEntity& forEntity, int catBits, int colBits, bool flipCull ) const;
	void createColComponents( unco::CEntity& forEntity, int catBits, int colBits, bool flipCull, dingus::CCollidableContainer& container ) const;

	void calcMass();
	dMass const& getMass() const { return mMass; }
	dMass& getMass() { return mMass; }

private:
	std::string			mName;
	TPartVector			mParts;
	TCollidePartsVector	mColParts;
	dMass				mMass;
};


#endif
