#ifndef __STATIC_ENTITY_CLASS_H
#define __STATIC_ENTITY_CLASS_H

#include "Tag.h"
#include "EntityClass.h"

// --------------------------------------------------------------------------

class CStaticEntityClass : public CEntityClass {
public:
	typedef std::map<std::string,CTag>		TNameTagMap;

public:
	CStaticEntityClass( const std::string& name );

	void	addTag( const CTag& tag ) { mTags.insert( std::make_pair(tag.getName(),tag) ); }
	TNameTagMap const& getTags() const { return mTags; }

private:
	TNameTagMap		mTags;
};


#endif
