 #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 1.1f, 40.0f ); // Araz: 1.2f
	}
	mLastFullContactTime[0] = CSystemClock::getInstance().getTime();
	mLastFullContactTime[1] = CSystemClock::getInstance().getTime();

	mSuperText[0] = NULL;
	mSuperText[1] = NULL;

	mDoubleText = NULL;

	mDouble2x[0] = NULL;
	mDouble2x[1] = NULL;

	mTimerText = NULL;

	mGameOverText = NULL;
}

CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start3");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
//		const char* name = i ? "monster" : "goom";
		const char* name = "goom";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/air01.lua" );

	mTimer = 3.0f * 60.0f;
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		// Araz: into update
		//mFollowCamera[i]->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		char buf[100];
		sprintf( buf, "score: %i", mScore[i] );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.85f-width,(i==0)?-1.0:1.0f-height), height, 0xFFFFFFFF
		);

	}

	const int bonuses = 10;
	float bonusTime[bonuses] = { 
		1.5f,
		2.9f,
		4.9f,
		6.9f,
		9.9f,
		14.9f,
		19.9f,
		24.9f,
		29.9f,
		59.9f };

	std::string bonusText[bonuses] = { 
		"leap frog",
		"on the air",
		"like a bird",
		"skyscrapper",
		"air freak",
		"mountain high",
		"sky is the limit",
		"high on your own supply",
		"rock it soul",
		"god-a-like" };



	for( i = 0; i < VEHICLES; ++i )
	{

		float dt = CSystemClock::getInstance().getTime() - mLastFullContactTime[i];
		if( dt > 1.0f )
		{

			char buf[100];
			sprintf( buf, "%i sec", (int)dt );
			float height = 0.09f;

			if( floor(dt) + 0.1f >= dt )
				height = .11f;



			std::string text = buf;
			for( int q = 0; q < bonuses; q++ )
			{
				if( bonusTime[q] >= dt && bonusTime[q] <= dt + 1.0f )
				{
					text = bonusText[q];
				}

				if( bonusTime[q] >= dt + 0.9f && bonusTime[q] <= dt + 0.95f )
					height = 0.095f;
			}

			float width = getTextRenderer().getWidth( text, height );
			mSuperText[i] = getTextRenderer().renderTextHeight( text,
				SVector2(-width/2.0f,i-0.5f-height/2.0f), height, 0xFFFFFFFF
			);
		}
	}

	float dt0 = CSystemClock::getInstance().getTime() - mLastFullContactTime[0];
	float dt1 = CSystemClock::getInstance().getTime() - mLastFullContactTime[1];

	if( dt0 > .75f )
		mScore[0] += (int)(dt0+1.0f);

	if( dt1 > .75f )
		mScore[1] += (int)(dt1+1.0f);

	if( dt0 > .75f && dt1 > .75f )
	{
		// double jump!

		mScore[0] += (int)(dt1+1.0f) * 2;
		mScore[1] += (int)(dt0+1.0f) * 2;

		float height = 0.2f;
		std::string bonus = "Double Jump!";
		float width = getTextRenderer().getWidth( bonus, height );
		mDoubleText = getTextRenderer().renderTextHeight( bonus,
			SVector2(-width/2.0f,-height/2.0f), height, 0xFFFFFFFF
		);

		
		for( int i = 0; i < VEHICLES; ++i ) {
			std::string x2 = "x2";
			float height = 0.08f;
			float width = getTextRenderer().getWidth( x2, height );
			mDouble2x[i] = getTextRenderer().renderTextHeight( x2,
				SVector2(0.99f-width,(i==0)?-1.0:1.0f-height), height, 0xFFFFFFFF
			);

		}
	}

	if( dt0 < .75f && dt1 < .75f )
	{
		mTimer -= CSystemClock::getInstance().getLastPerformDuration();
	}
	else
	{
		if( mTimer > 0.0f )
			mTimer += CSystemClock::getInstance().getLastPerformDuration();
	}

	if( mTimer < 0.0f )
		mTimer = 0.0f;

	char buf[100];
	sprintf( buf, "timer: %.1f", mTimer );
	float height = 0.06f;
	float width = getTextRenderer().getWidth( buf, height );
	mTimerText = getTextRenderer().renderTextHeight( buf,
		SVector2(-0.95f,-height*0.6f), height, 0xFFFFFFFF
	);

	if( mTimer <= 0.0f )
	{
		float height = 0.2f;
		std::string gameOver = "game over";
		float width = getTextRenderer().getWidth( gameOver, height );
		mGameOverText = getTextRenderer().renderTextHeight( gameOver,
			SVector2(-width/2.0f,-height/2.0f), height, 0xFFFFFFFF
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
		delete mSuperText[i]; mSuperText[i]= NULL; mOldSuperValue[i] = 0;
		delete mDouble2x[i]; mDouble2x[i]= NULL;
	}
	delete mTimerText; mTimerText= NULL;

	delete mDoubleText; mDoubleText = NULL;
	delete mGameOverText; mGameOverText = NULL;
}

void CMyGame::onUpdate()
{
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyBoost[VEHICLES] = { ' ', ' ' };

	for( int i = 0; i < VEHICLES; ++i ) {
		// Araz: moved here
		mFollowCamera[i]->update( 1/200.0f, SVector3(0,0,0), true );
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}

		if( mTimer > 0.0f )
		{
			float accel = 0.0f;
			if( GetAsyncKeyState(keyUp[i]) )
				accel += 1;
			if( GetAsyncKeyState(keyDown[i]) )
				accel -= 1;

			if( GetAsyncKeyState(keyBoost[i]) )
				accel *= 1.5f;


			float turn = 0.0f;
			if( GetAsyncKeyState(keyLeft[i]) )
				turn += 1;
			if( GetAsyncKeyState(keyRight[i]) )
				turn -= 1;

			mVehicle[i]->control( accel, turn );
		}
		else
		{
			mVehicle[i]->control( 0.0f, 0.0f );

		}
	}



/*	for( i = 0; i < VEHICLES; ++i )
	{
		float dt = CSystemClock::getInstance().getTime() - mLastFullContactTime[i];
		if( dt > .75f )
			mScore[i] += (int)(dt+1.0f);
	}*/





	CGameInfo::getInstance().getLevel().update();
}

void CMyGame::onContact( CVehicle const& vehicle )
{
	if( &vehicle == mVehicle[0] )
		mLastFullContactTime[0] = CSystemClock::getInstance().getTime();

	if( &vehicle == mVehicle[1] )
		mLastFullContactTime[1] = CSystemClock::getInstance().getTime();

/*	float dt = CSystemClock::getInstance().getTime() - mLastContactTime;
	if( dt > 0.01f )
	{
		mLastContactTime = CSystemClock::getInstance().getTime();
		return;
	}*/

}
