#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
/*#include <jam/BaseGame.h>
#include <jam/utils/FollowCameraController.h>
#include <jam/entity/Vehicle.h>*/
#include "../../jam/jam/BaseGame.h"
#include "../../jam/jam/utils/FollowCameraController.h"
#include "../../jam/jam/entity/Vehicle.h"
//#include ".."


//class CTextRenderer;
//class CTextRenderer::CRenderedText

class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame> {
public:
	enum { VEHICLES = 2 };
public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

	void onContact( CVehicle const& vehicle );

private:
	void	createLevel( const std::string& name );
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;

private:
	CFollowCameraController*	mFollowCamera[VEHICLES];
	CVehicle*					mVehicle[VEHICLES];
	int							mScore[VEHICLES];
	int							mLastScore[VEHICLES];
	unco::CTextRenderer::CRenderedText*	mScoreText[VEHICLES];
	unco::CTextRenderer::CRenderedText*	mSuperText[VEHICLES];
	unco::CTextRenderer::CRenderedText*	mDoubleText;
	unco::CTextRenderer::CRenderedText*	mDouble2x[VEHICLES];
	unco::CTextRenderer::CRenderedText*	mTimerText;
	unco::CTextRenderer::CRenderedText*	mGameOverText;

	float						mOldSuperValue[VEHICLES];

	float						mTimer;


	float						mLastFullContactTime[VEHICLES];
	float						mLastContactTime;
};


#endif
