#include "stdafx.h"
#pragma hdrstop

#include "BaseGame.h"
#include <unco/kernel/Contexts.h>
#include <unco/kernel/AppContext.h>
#include <dingus/kernel/SystemClock.h>
#include <dingus/physics-ode/PhysicsContext.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <unco/component/vis/VisibilityComponent.h>

#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/TextureBundle.h>


unco::SStartupParams CBaseGame::getStartupParams()
{
	unco::SStartupParams p;
	p.windowTitle			= "Arklys by DarkCloud & erte @ LTGameJam2003";
	p.dataPath				= "../data/";
	p.windowWidth			= 640;
	p.windowHeight			= 480;
	p.minColorBits			= 4;
	p.minAlphaBits			= 0;
	p.minZBits				= 16;
	p.minStencilBits		= 0;
	p.usesZBuffer			= true;
	p.startFullscreen		= false;
	p.showCursorFullscreen	= false;
	return p;
}

bool CBaseGame::checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format )
{
	//if( (caps.VertexShaderVersion < D3DVS_VERSION(1,1)) && (behavior & D3DCREATE_HARDWARE_VERTEXPROCESSING) )
	//	return false;
	return true;
}


CBaseGame::CBaseGame()
{
}

void CBaseGame::initialize()
{
	//
	// vis

	unco::CContexts::getVisCtx().addDB( DB_OVERLAY, *(new dingus::CDummyVisibilityDB()) );
	unco::CVisibilityComponent* vis = new unco::CVisibilityComponent( DB_OVERLAY );
	mGlobalContainer.addComponent( *vis );

	//
	// IB quads

	dingus::CResourceId ibQuadsID = "ibQuads";
	dingus::CIndexBufferBundle::getInstance().registerIB( ibQuadsID, 16000*6, D3DFMT_INDEX16, mIBFillerQuads );

	//
	// billboards

	mBillboards = new unco::CBillboardsComponent(
		*dingus::CIndexBufferBundle::getInstance().getResourceById(ibQuadsID),
		"bill.fx", dingus::CRenderContext::LAYER_COUNT-1 );
	mGlobalContainer.addComponent( *mBillboards );
	vis->addListener( *mBillboards );

	//
	// text renderer

	mTextRenderer = new unco::CTextRenderer(
		mBillboards->getBillboards(),
		*dingus::CTextureBundle::getInstance().getResourceById("font1.png"),
		dingus::SVector2(0,0), dingus::SVector2(1,1), '!', 9, 11 );

	//
	// physics params

	dingus::CPhysicsContext& phys = unco::CContexts::getPhysicsCtx();
	phys.setGravity( SVector3(0,-9.81f,0) );
	phys.setERP( 0.6f ); // Araz: none
	phys.setCFM( 0.0004f ); //0.0003

	dWorldSetAutoDisableSteps( phys, 10 );
	dWorldSetAutoDisableThreshold( phys, 0.008 );

	//
	// global collision listener

	dingus::CCollisionContext& col = unco::CContexts::getCollisionCtx();
	col.setGlobalColListener( &mCommonColListener );

	//
	// viewing stuff

	for( int i = 0; i < VIEW_OVERLAY; ++i ) {
		mRenderTarget[i].setClearValues( true, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xFF204060, 1.0f, 0 );
		mCamera[i] = new unco::CCamera( mRenderTarget[i] );
		mGlobalContainer.addEntity( mCamera[i] );
	}
	// overlay camera and RT
	mRenderTarget[VIEW_OVERLAY].setClearValues( false, D3DCLEAR_TARGET, 0x0, 1.0f, 0 );
	mCamera[VIEW_OVERLAY] = new unco::CCamera( mRenderTarget[VIEW_OVERLAY], DB_OVERLAY );
	mGlobalContainer.addEntity( mCamera[VIEW_OVERLAY] );

	//
	// attach globals

	mGlobalContainer.attach();

	//
	// initialize game

	onInitialize();
}

void CBaseGame::onBeginPerform()
{
	unco::CAppContext& appctx = unco::CAppContext::getInstance();
	for( int i = 0; i < VIEW_OVERLAY; ++i ) {
		mCamera[i]->setProjectionParams(
			0.20f * 3.1415927f,
			unco::CAppContext::getInstance().getWindowAspect() * 2.0f,
			1.0f, 500.0f
		);
		mRenderTarget[i].setSettingViewport( true );
		mRenderTarget[i].getViewport().X = 0;
		mRenderTarget[i].getViewport().Y = i ? appctx.getScreenHeight()/2 : 0;
		mRenderTarget[i].getViewport().Width = appctx.getScreenWidth();
		mRenderTarget[i].getViewport().Height = i ? appctx.getScreenHeight()-appctx.getScreenHeight()/2:appctx.getScreenHeight()/2;
		mRenderTarget[i].getViewport().MinZ = 0.0f;
		mRenderTarget[i].getViewport().MaxZ = 1.0f;
		mCamera[i]->activate();
	}
	mRenderTarget[VIEW_OVERLAY].setSettingViewport( true );
	mRenderTarget[VIEW_OVERLAY].getViewport().X = 0;
	mRenderTarget[VIEW_OVERLAY].getViewport().Y = 0;
	mRenderTarget[VIEW_OVERLAY].getViewport().Width = appctx.getScreenWidth();
	mRenderTarget[VIEW_OVERLAY].getViewport().Height = appctx.getScreenHeight();
	mRenderTarget[VIEW_OVERLAY].getViewport().MinZ = 0.0f;
	mRenderTarget[VIEW_OVERLAY].getViewport().MaxZ = 1.0f;
	mCamera[VIEW_OVERLAY]->activate();

	onBeginCycle();
}

void CBaseGame::onEndPerform()
{
	onEndCycle();
}

void CBaseGame::perform()
{
	mGlobalContainer.update();
	onUpdate();
}

void CBaseGame::shutdown()
{
}
