#ifndef _BALL_H_
#define _BALL_H_

#include "ThingEntity.h"
#include "StaticEntity.h"
#include "Vehicle.h"
#include <dingus/kernel/SystemClock.h>
#include <string>
using namespace std;


class CBall : public CThingEntity
{
	int dodetache;
protected:
public:
	double timer;
	
	static CBall* create(string ballname,string marker);

	CBall(const std::string& name, const CEntityClass& clazz, 
		  int colBits, unco::CVisibilityComponent& visComp, float mass) :
	CThingEntity( name, clazz, colBits,visComp, mass )
	{	dodetache=0;
		timer = dingus::CSystemClock::getInstance().getTime();
	}
	
	virtual void setPosition(float x,float y,float z,int xx,int yy,int zz);
	void remove() {dodetache=1;};
	virtual bool onLevelBound();
	virtual void internalUpdate();

	void init(){};

};


class PickUpBall: public CBall
{
	int _item;
public:
	static PickUpBall* createPickUpBall(string ballname,string marker,int item=0);

	PickUpBall(const std::string& name, const CEntityClass& clazz, 
		  int colBits, unco::CVisibilityComponent& visComp, float mass) :
		CBall( name, clazz, colBits,visComp, mass ) {_item=0;}
	
	void setItem(int item) {_item=item;};
	int getItem() {return _item;}
};

class FireBall:public CBall
{
public:
	static FireBall* createFireBall(string ballname,string marker,CVehicle *vehicle);

	FireBall(const std::string& name, const CEntityClass& clazz, 
		  int colBits, unco::CVisibilityComponent& visComp, float mass) :
		CBall( name, clazz, colBits,visComp, mass ) {}
	
	//virtual void setPosition(float x,float y,float z);
	virtual bool onLevelBound() { detach(); discard(); return true;}

};


class CRidingBox:public CStaticEntity//:public CThingEntity
{
	int dodetache;
protected:
public:
	double timer;
	float dir;
	float maxhight;
	float starty;


	static CRidingBox* create(string ballname,string marker);

	CRidingBox(const std::string& name, const CStaticEntityClass& clazz, 
		  int colBits, unco::CVisibilityComponent& visComp ) :
	CStaticEntity( name, clazz, colBits, false, visComp )
	{	dodetache=0;
		timer = dingus::CSystemClock::getInstance().getTime();
	}

	
	
	//virtual void setPosition(float x,float y,float z,int xx,int yy,int zz);
	//void remove() {dodetache=1;};
	//virtual bool onLevelBound();
	virtual void internalUpdate();

};


#endif