#ifndef __ENTITY_CLASSES_H
#define __ENTITY_CLASSES_H

#include "EntityClass.h"
#include "StaticEntityClass.h"
#include "VehicleClass.h"



namespace dingus {
	class CLuaValue;
	class CLuaWrapper;
};


class CEntityClasses {
public:
	typedef std::map<std::string,CStaticEntityClass*>	TStaticEntityClassMap;
	typedef std::map<std::string,CEntityClass*>			TEntityClassMap;
	typedef std::map<std::string,CVehicleClass*>		TVehicleClassMap;

public:
	CEntityClasses();
	~CEntityClasses();

	CStaticEntityClass const* getStaticEntityClass( const std::string& name ) const;
	TStaticEntityClassMap const& getStaticEntityClasses() const { return mStaticEntityClasses; }

	CEntityClass const* getThingEntityClass( const std::string& name ) const;
	TEntityClassMap const& getThingEntityClasses() const { return mThingEntityClasses; }

	CVehicleClass const* getVehicleClass( const std::string& name ) const;
	TVehicleClassMap const& getVehicleClasses() const { return mVehicleClasses; }

private:
	CStaticEntityClass* getStaticEntityClass( const std::string& name );
	CEntityClass* getThingEntityClass( const std::string& name );
	CVehicleClass* getVehicleClass( const std::string& name );
	
	void	readStaticEntityTags();
	void	readStaticEntityParts();
	void	readThingEntityParts();
	void	readVehicles();
	void	readColliders();

	static void readMeshParts( dingus::CLuaValue& luaParts, CEntityClass& clazz );
	static void readVehicleClass( CVehicleClass& vc );
	static void readColParts( dingus::CLuaValue& luaCol, CEntityClass& clazz );
	static void readVehicleColliders( CVehicleClass& vc );
	static void readVehicleTags( CVehicleClass& vc );
	static void readVehicleAppearance( CVehicleClass& vc );

private:
	TStaticEntityClassMap	mStaticEntityClasses;
	TEntityClassMap			mThingEntityClasses;
	TVehicleClassMap		mVehicleClasses;
};


#endif
