#ifndef __STATIC_ENTITY_H
#define __STATIC_ENTITY_H

#include "BaseEntity.h"
#include "StaticEntityClass.h"
#include "CollideClasses.h"


class CStaticEntity : public CBaseEntity {
public:
	CStaticEntity( const std::string& name, const CStaticEntityClass& clazz, int colBits, bool flipCull, unco::CVisibilityComponent& visComp )
		: CBaseEntity( name, clazz, 1<<COL_ENTITY_STATIC, colBits, flipCull, visComp ) { }

	const CStaticEntityClass& getStaticClass() const { return (const CStaticEntityClass&)getClass(); }
};


#endif
