#ifndef __TAG_H
#define __TAG_H


class CTag {
public:
	CTag( const std::string& name ) : mName(name) { mMatrix.identify(); };
	CTag( const CTag& rhs ) : mName(rhs.mName), mMatrix(rhs.mMatrix) { }
	CTag const& operator=( const CTag& rhs ) { mName = rhs.mName; mMatrix = rhs.mMatrix; return *this; }

	std::string const& getName() const { return mName; }

	SMatrix4x4 const& getMatrix() const { return mMatrix; }

	void setMatrix( SMatrix4x4 const& m ) { mMatrix = m; }

private:
	std::string		mName;
	SMatrix4x4		mMatrix;
};


class CTagInstance {
public:
	CTagInstance( const CTag& tag );

	CTag const& getTag() const { return *mTag; }

	SMatrix4x4 const& getWorldMatrix() const { return mWorldMatrix; }
	SMatrix4x4& getWorldMatrix() { return mWorldMatrix; }

	SVector3 const& getFlips() const { return mFlips; }
	void	setFlips( const SVector3& f ) { mFlips = f; }

	void	setLink( CTagInstance* link ) { mLink = link; }
	CTagInstance* getLink() const { return mLink; }
	bool	isLinked() const { return mLink!=0; }

	void*	getOwner() const { return mOwner; }
	void	setOwner( void* data ) { mOwner = data; }

private:
	const CTag*		mTag;
	SMatrix4x4		mWorldMatrix;
	CTagInstance*	mLink;
	SVector3		mFlips;
	void*			mOwner;
};


#endif
