#ifndef __VEHICLE_CLASS_H
#define __VEHICLE_CLASS_H

#include "EntityClass.h"
#include "Tag.h"

// --------------------------------------------------------------------------

class CVehicleClass : public boost::noncopyable {
public:
	enum eWheel { WHEEL_FR = 0, WHEEL_FL, WHEEL_BR, WHEEL_BL, MAX_WHEELS };
	static const std::string BODY_NAME;
	static const std::string WHEEL_NAMES[MAX_WHEELS];
	static const std::string TAG_NAMES[MAX_WHEELS];
public:
	CVehicleClass( const std::string& name );
	~CVehicleClass();

	const std::string& getName() const { return mName; }

	const CEntityClass& getBodyClass() const { return *mBodyClass; }
	CEntityClass& getBodyClass() { return *mBodyClass; }
	const CEntityClass& getWheelClass( eWheel w ) const { return *mWheelClass[w]; }
	CEntityClass& getWheelClass( eWheel w ) { return *mWheelClass[w]; }

	const CTag& getBodyWheelTag( eWheel w ) const { return *mBodyWheelTags[w]; }
	CTag& getBodyWheelTag( eWheel w ) { return *mBodyWheelTags[w]; }
	const CTag& getWheelTag( eWheel w ) const { return *mWheelTags[w]; }
	CTag& getWheelTag( eWheel w ) { return *mWheelTags[w]; }

	CEntityClass* getClassByName( const std::string& n );
	CTag* getBodyWheelTagByName( const std::string& n );
	CTag* getWheelTagByName( const std::string& n );

private:
	std::string		mName;
	CEntityClass*	mBodyClass;
	CEntityClass*	mWheelClass[MAX_WHEELS];
	CTag*			mBodyWheelTags[MAX_WHEELS];
	CTag*			mWheelTags[MAX_WHEELS];
};


#endif
