#include "../stdafx.h"
#pragma hdrstop

#include "ball.h"
#include "../level/GameInfo.h"

//#include <jam/GameLevelCreator.h>
//#include <jam/level/GameInfo.h>
#include "../level/Level.h"
#include "../entity/EntityClasses.h"
//#include <jam/entity/Vehicle.h>
//#include <dingus/kernel/SystemClock.h>
//#include <jam/entity/ThingEntity.h>

CBall* CBall::create(string ballname,string marker)
{
	CBall*                      e;
	CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
	assert( clazz );
	const float THING_MASS = 100.0f;
	CLevel &level=CGameInfo::getInstance().getLevel();
	e = new CBall(ballname, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), CGameInfo::getInstance().getLevel().getVisThing(), THING_MASS );
	level.getThingEntities().addEntity( e );
	e->getMatrix() = level.getMarkers().getValue(marker);
	e->getMatrix().getOrigin().y += 10.0f;
	e->getPhysComp().setMatrixPORed( e->getMatrix() );
	e->attach();
	level.getBounds().addBoundable( e->getWorldMatrix(), e );
	return e;
}


CRidingBox* CRidingBox::create(string ballname,string marker)
{
	CRidingBox*  e;
	CStaticEntityClass const* clazz = CGameInfo::getInstance().getClasses().getStaticEntityClass( "RoadWide" );
	assert( clazz );
	//const float THING_MASS = 100.0f;
	CLevel &level=CGameInfo::getInstance().getLevel();
	e = new CRidingBox(ballname, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), CGameInfo::getInstance().getLevel().getVisStatic());
	level.getStaticEntities().addEntity( e );
	e->getMatrix() = level.getMarkers().getValue(marker);
	e->getMatrix().getOrigin().y += 1.0f;
	//e->getPhysComp().setMatrixPORed( e->getMatrix() );
	e->attach();
	//level.getBounds().addBoundable( e->getWorldMatrix(), e );

	e->timer = dingus::CSystemClock::getInstance().getTime();
	e->maxhight = 10;
	e->starty = e->getMatrix().getOrigin().y;
	e->dir = 1;
	return e;
}

FireBall* FireBall::createFireBall(string ballname,string marker,CVehicle *vehicle)
{
	FireBall*                      e;
	CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
	assert( clazz );
	const float THING_MASS = 100.0f;
	CLevel &level=CGameInfo::getInstance().getLevel();
	e = new FireBall(ballname, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), CGameInfo::getInstance().getLevel().getVisThing(), THING_MASS );
	level.getThingEntities().addEntity( e );
	//e->getMatrix() = level.getMarkers().getValue(marker);
	//e->getMatrix().getOrigin().y += 10.0f;
	//e->getMatrix() = level.getMarkers().getValue(marker);
	e->getMatrix() = vehicle->getMatrix();
	e->getMatrix().getOrigin() += e->getMatrix().getAxisZ() *3.0f;
	e->getPhysComp().setMatrixPORed( e->getMatrix() );
	
	
	e->attach();
	SVector3 a=e->getMatrix().getAxisZ() * 1500000.0f ;
	e->getPhysComp().getPhysicsable().addForce(a );

	
	level.getBounds().addBoundable( e->getWorldMatrix(), e );
	return e;
}




PickUpBall* PickUpBall::createPickUpBall(string ballname,string marker, int item)
{
	PickUpBall*                      e;
	CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
	assert( clazz );
	const float THING_MASS = 100.0f;
	CLevel &level=CGameInfo::getInstance().getLevel();
	e = new PickUpBall(ballname, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), CGameInfo::getInstance().getLevel().getVisThing(), THING_MASS );
	level.getThingEntities().addEntity( e );
	e->getMatrix() = level.getMarkers().getValue(marker);
	e->getMatrix().getOrigin().y += 5.0f;
	e->getPhysComp().setMatrixPORed( e->getMatrix() );
	//e->getMatrix() = level.getMarkers().getValue(marker);
	//e->getMatrix() = vehicle->getMatrix();
	e->setColor(0xffff0000);
	//e->getMatrix().getOrigin() += e->getMatrix().getAxisZ() *3.0f;
	//e->getPhysComp().setMatrixPORed( e->getMatrix() );
	
	
	e->attach();
	//SVector3 a=e->getMatrix().getAxisZ() * 150000.0f ;
	//e->getPhysComp().getPhysicsable().addForce(a );

	
	level.getBounds().addBoundable( e->getWorldMatrix(), e );
	return e;
}


void CBall::setPosition(float x,float y,float z,int xx,int yy,int zz)
{
	
	getMatrix().getOrigin().y += y;
	getMatrix().getOrigin().x += x;
	getMatrix().getOrigin().z += z;


	/*
	mgetMatrix().getOrigin().getAxisy * getMatrix().getOrigin().y * yy;
	getMatrix().getOrigin().x = getMatrix().getOrigin().x * xx;
	getMatrix().getOrigin().z = getMatrix().getOrigin().y * zz;*/
	
}

void CBall::internalUpdate()
{
	if (dodetache==1) 
	{
		dodetache = 0;
		detach();
		discard();
	}
}

void CRidingBox::internalUpdate()
{
	double timer1 = dingus::CSystemClock::getInstance().getTime();

	if (timer1-timer>0.005)
	{
		getMatrix().getOrigin().y += 0.03 * dir;
		if (getMatrix().getOrigin().y - starty >maxhight||getMatrix().getOrigin().y - starty<-5)
			dir = dir * (-1);
	}

	timer = timer1;
}


bool CBall::onLevelBound()
{
	detach();
	getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("start1");
	getMatrix().getOrigin().y += 10;
	getPhysComp().setMatrixPORed(getMatrix() );
	attach();
	//m_bOutOfBounds = true;
	return true;
}