  #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <dingus/kernel/SystemClock.h>
#include <jam/entity/ThingEntity.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 144.0f );
	}
}
CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = i ? "monster" : "goom";
		ArklysVehicle *arklys=new ArklysVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		mVehicle[i] = arklys;
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mVehicle[i]->getWheel(0).setColor( 0xFFFF0000 );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}
	ArklysVehicle *arklys=mVehicle[0];
	arklys->setGun(new Weapon);
	arklys=mVehicle[1];
	arklys->setGun(new DualWeapon);
	
	PickUpBall *b=PickUpBall::createPickUpBall("pickup1","start4",1);
	b=PickUpBall::createPickUpBall("pickup2","start2",2);
	//FireBall *b=FireBall::createFireBall("b2","start2");
	//b->setPosition();
	//b=FireBall::createFireBall("b1","start1");
	//CBall::create("start1");

	CRidingBox *r=CRidingBox::create("rider1", "start3");

}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/tower1.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		char buf[100];
		sprintf( buf, "points: %i", mScore[i] );
		float height = 0.09f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xFFFFFFFF
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
	}
}

void CMyGame::onUpdate()
{
	
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyFire[VEHICLES]={VK_RCONTROL, VK_SPACE};

	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( 1.0f/200.0f, SVector3(0,0,0), true );
		mVehicle[i]->tim();
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1; // araz: 3
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1; // araz
			/*
			if (accel>0)
			    accel -= 2000000000000;
			else
				accel -=1;
				*/

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;
		if (GetAsyncKeyState(keyFire[i]))if (mVehicle[i]->timer > 50)
		{
			mVehicle[i]->timer = 0;
			mVehicle[i]->shoot(mVehicle[i]);
		}
		mVehicle[i]->control( accel, turn );
	}

	CGameInfo::getInstance().getLevel().update();
}
