#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
#include <jam/BaseGame.h>
#include <jam/utils/FollowCameraController.h>
#include <jam/entity/Vehicle.h>
#include <jam/entity/ball.h>
#include <jam/entity/arklysvehicle.h>

class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame> {
public:
	enum { VEHICLES = 2 };
public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

private:
	void	createLevel( const std::string& name );
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;

private:
	CFollowCameraController*	mFollowCamera[VEHICLES];
	ArklysVehicle*					mVehicle[VEHICLES];
	int							mScore[VEHICLES];
	CTextRenderer::CRenderedText*	mScoreText[VEHICLES];
};


#endif
