#ifndef __THING_ENTITY_H
#define __THING_ENTITY_H

#include "BasePhysicsEntity.h"
#include "CollideClasses.h"


class CThingEntity : public CBasePhysicsEntity {
public:
	CThingEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp, float mass )
		:	CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_THING, colBits, false, visComp, mass ), mNeedDiscard( false )
	{ }

	void requestDiscard() { mNeedDiscard = true; }

	virtual void internalUpdate();

private:
	bool	mNeedDiscard;
};


#endif
