#ifndef __GAME_INFO_H
#define __GAME_INFO_H

#include <dingus/utils/Singleton.h>

class CLevel;
class CEntityClasses;


class CGameInfo : public dingus::CSingleton<CGameInfo> {
public:
	const CEntityClasses& getClasses() const { return *mClasses; }
	
	const CLevel&	getLevel() const { return *mLevel; }
	CLevel&			getLevel() { return *mLevel; }
	void			createNewLevel();

	void signalFinish() { mFinished = true; }
	bool finishReached() const { return mFinished; }

private:
	CGameInfo();
	~CGameInfo();
	static CGameInfo* createInstance() { return new CGameInfo(); }
	static void deleteInstance( CGameInfo& l ) { delete &l; }
	friend class dingus::CSingleton<CGameInfo>;

private:
	CEntityClasses*	mClasses;
	CLevel*			mLevel;

	bool			mFinished;
};


#endif
