 #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include "WallCreator.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/ThingEntity.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
//		mFollowCamera[i] = new CFollowCameraController( 50.0f, 30.0f, 8.0f );
		mFollowCamera[i] = new CFollowCameraController( i ? 8.0f : 8.0f, i ? 2.0f : 2.0f, 8.0f );
	}

	mCurrentAccel[0] = 0.0f;
	mCurrentAccel[1] = 0.0f;
}

CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "m_start02" : "m_start01");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = i ? "monster" : "monster";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}

	// create wall
	CWallCreator wcr( creator );

	wcr.placeObjects( "o_sign", "m_wallX01", 10, 6, 50, false );
	wcr.placeObjects( "o_sign", "m_wallX04", 10, 3, 50, false );
	wcr.placeObjects( "Barrel", "m_wallX02", 10, 4, 100, false );

	wcr.createWall( "Barrel", "m_wall01s", "m_wall01e", 7, 1, 1.2f, 200.0f );
	wcr.createWall( "Barrel", "m_wall02s", "m_wall02e", 7, 1, 1.2f, 200.0f );
	wcr.createWall( "Barrel", "m_wall03s", "m_wall03e", 6, 1, 1.2f, 400.0f );

	wcr.createWall( "Barrel", "m_wall11s", "m_wall11e", 9, 1, 1.2f, 200.0f );
	wcr.createWall( "Barrel", "m_wall12s", "m_wall12e", 6, 1, 1.2f, 200.0f );
	wcr.createWall( "Barrel", "m_wall13s", "m_wall13e", 5, 1, 1.2f, 400.0f );
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/b-drive01.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		char buf[100];
		sprintf( buf, "%i iridium spheres", mVehicle[i]->collected() );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xFFFFFFFF
		);

		if( CGameInfo::getInstance().finishReached() )
		{
			// finished
			float height = 0.1f;

			char* result = mVehicle[i]->collected() > mVehicle[(i%2)^1]->collected() ? "WINNER" : "LOSER";
			if( mVehicle[0]->collected() == mVehicle[1]->collected() )
				result = "BUTT-HEADS-EQUAL";

			float width = getTextRenderer().getWidth( result, height );
			mFinishText[i] = std::auto_ptr<CTextRenderer::CRenderedText>(
				getTextRenderer().renderTextHeight( result,
				SVector2(-width/2.0f,i-height-0.5f), height, 0xFFFFFF00
				)
			);
		}
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
	}
}

void CMyGame::onUpdate()
{
//	if( mVehicle[0]->collected() > 2 )
//		CGameInfo::getInstance().signalFinish();

	if( CGameInfo::getInstance().finishReached() )
	{
		// finished
	}
	else
	{
		int keyUp[VEHICLES] = { VK_UP, 'W' };
		int keyDown[VEHICLES] = { VK_DOWN, 'S' };
		int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
		int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
		int keyBreak[VEHICLES] = { VK_SPACE, 'Q' };

		for( int i = 0; i < VEHICLES; ++i ) {
			if( mVehicle[i]->isOutOfBounds() ) {
				mVehicle[i]->detach();
				mVehicle[i]->setOutOfBounds( false );
				mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "m_start02" : "m_start01");
				mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
				mVehicle[i]->attach();
				++mScore[VEHICLES-i-1];
				continue;
			}
			if( !GetAsyncKeyState(keyUp[i]) && !GetAsyncKeyState(keyDown[i]) )
			{
				float sign = mCurrentAccel[i] > 0.0f ? 1.0f : -1.0f;
				float magn = fabsf( mCurrentAccel[i] );

				if( magn >= 0.0f ) magn -= 0.1f;
				if( magn <= 0.0f ) magn = 0.0f;
				
				mCurrentAccel[i] = magn * sign;
			}

			if( GetAsyncKeyState(keyUp[i]) ) {
				if( mCurrentAccel[i] <= 2.0f )
					mCurrentAccel[i] += 0.1f;
			}

			if( GetAsyncKeyState(keyDown[i]) ) {
				if( mCurrentAccel[i] >= -2.0f )
					mCurrentAccel[i] -= 0.2f;
			}
			
			float turn = 0.0f;
			if( GetAsyncKeyState(keyLeft[i]) )
				turn += 1;
			if( GetAsyncKeyState(keyRight[i]) )
				turn -= 1;

			if( GetAsyncKeyState(keyBreak[i]) )
				mCurrentAccel[i] = 0.0f;

			mVehicle[i]->control( mCurrentAccel[i], turn );
		}
	}

	CGameInfo::getInstance().getLevel().update();
}
