#include "stdafx.h"
#pragma hdrstop

#include "WallCreator.h"
#include <jam/entity/ThingEntity.h>
#include <jam/level/Level.h>
#include <jam/level/GameInfo.h>

static inline float rnd( float m ) {
	return (float)rand() / (float)RAND_MAX * m;
}

static inline float rnd_m( float m ) {
	return ( ((float)rand() / (float)RAND_MAX) - 0.5f) * m;
}

void CWallCreator::createWall( std::string const& clazzName, std::string const& originMarker1, std::string const& originMarker2, int perX, int perY, float h, float mass )
{
	CLevel& level = CGameInfo::getInstance().getLevel();

	assert( level.getMarkers().isValue( originMarker1 ) );
	assert( level.getMarkers().isValue( originMarker2 ) );

	SVector3 origin1 = level.getMarkers().getValue(originMarker1).getOrigin();
	SVector3 origin2 = level.getMarkers().getValue(originMarker2).getOrigin();

	origin1.y += -(h / 2.0f) - 0.2f;
	origin2.y += -(h / 2.0f) - 0.2f;

	SVector3 d_o = (origin2 - origin1);

	for( int i = 0; i < perY; i++ )
	{
		for( int j = 0; j < perX; j++ )
		{
			float u = (float)j / (float)perX;

			SMatrix4x4 origin_temp;

			SVector3 o = origin1 + d_o*u +
				SVector3( 0, (h*i + 0.001f), 0 );
			D3DXMatrixTranslation( &origin_temp, o.x, o.y, o.z );

			std::string name = mNameGenerator.generateName( clazzName );
			mCreator.createThingEntity(
				name,
				clazzName, "", origin_temp );

			CThingEntity* thing1 = (CThingEntity*)level.getThingEntities().findEntity( name ).get();

			SPhysicsMass mass_s;
			mass_s.mass = mass;

			thing1->getPhysComp().getPhysicsable().setMass( mass_s );
			thing1->getPhysComp().getPhysicsable().disable();
		}
	}
}

void CWallCreator::placeObjects(std::string const& clazzName, std::string const& originMarker,
								int count, float radius, float mass, bool disable )
{
	CLevel& level = CGameInfo::getInstance().getLevel();

	SVector3 origin_v = level.getMarkers().getValue(originMarker).getOrigin();

	for( int i = 0; i < count; i++ )
	{
		SMatrix4x4 rm1, rm2, rm3;
		D3DXMatrixRotationX(&rm1, rnd(D3DX_PI*2.0f) );
		D3DXMatrixRotationY(&rm2, rnd(D3DX_PI*2.0f) );
		D3DXMatrixRotationZ(&rm3, rnd(D3DX_PI*2.0f) );

		std::string name = mNameGenerator.generateName( clazzName );

		SMatrix4x4 origin_temp;
		SVector3 o(
			origin_v.x + rnd_m(radius),
			origin_v.y + 2.0f + rnd(2.0f),
			origin_v.z + rnd_m(radius)
		);
		D3DXMatrixTranslation( &origin_temp, o.x, o.y, o.z );

		origin_temp = rm1 * rm2 * rm3 * origin_temp;
		mCreator.createThingEntity( name, clazzName, "", origin_temp );

		CThingEntity* thing1 = (CThingEntity*)level.getThingEntities().findEntity( name ).get();

		SPhysicsMass mass_s;
		mass_s.mass = mass;

		thing1->getPhysComp().getPhysicsable().setMass( mass_s );

		if( disable )
			thing1->getPhysComp().getPhysicsable().disable();
	}
}

