#ifndef WALL_CREATOR_H_
#define WALL_CREATOR_H_

#include "EntityNameGenerator.h"
#include <jam/GameLevelCreator.h>

class CWallCreator
{
public:
	CWallCreator( CGameLevelCreator& creator )
		:	mCreator( creator ) {}

	void createWall(
		std::string const& clazzName,
		std::string const& originMarker1,
		std::string const& originMarker2,
		int perX, int perY,
		float h,
		float mass );

	void placeObjects(
		std::string const& clazzName,
		std::string const& originMarker,
		int count,
		float radius,
		float mass, bool disable );

private:
	CGameLevelCreator&		mCreator;
	CEntityNameGenerator	mNameGenerator;
};

#endif // WALL_CREATOR_H_
