function makePart( tex, mode )
	local fxs = { 'textured.fx', 'texturedAlpha.fx' }
	local layers = { 0, 1 }
	return { texture=tex, fx=fxs[mode], layer=layers[mode] }
end
function makeMesh( mesh, pts )
	return { name=mesh, parts=pts }
end
modeSimple = 1
modeAlpha = 2

partsRoadWide = {
	makePart( 'roadWide01.jpg', modeSimple ),
}
partsSquare = {
	makePart( 'square01.png', modeSimple ),
}

staticMeshes = {
makeMesh( 'RoadWide', partsRoadWide ),
makeMesh( 'TurnWide', partsRoadWide ),
makeMesh( 'TurnWide45', partsRoadWide ),
makeMesh( 'WideRise', partsRoadWide ),
}

thingMeshes = {
makeMesh( 'o_sign', { makePart( 'sign01.png', modeSimple ) } ),
makeMesh( 'o_marker', { makePart( 'rgb01.png', modeSimple ) } ),
makeMesh( 'Sphere', { makePart( 'rgb01.png', modeSimple ) } ),
makeMesh( 'Barrel', { makePart( 'square01.png', modeSimple ) } ),
makeMesh( 'pickup_lame', { makePart( 'roadSide01.png', modeSimple ) } ),
makeMesh( 'finish_lame', { makePart( 'rgb.png', modeSimple ) } ),
}
