#include "stdafx.h"
#pragma hdrstop

#include "GameLevelCreator.h"
#include "entity/StaticEntity.h"
#include "entity/ThingEntity.h"
#include "entity/EntityClasses.h"
#include "entity/CollideClasses.h"
#include "level/Level.h"
#include "level/GameInfo.h"


void CGameLevelCreator::createStaticEntity(
		const std::string& name, const std::string& clazzName,
		const SMatrix4x4& matrix, bool flipCull )
{
	CLevel& level = CGameInfo::getInstance().getLevel();
	level.getBounds().extend( matrix.getOrigin() );
	CStaticEntityClass const* clazz = CGameInfo::getInstance().getClasses().getStaticEntityClass( clazzName );
	assert( clazz );
	CStaticEntity* e = new CStaticEntity( name, *clazz, 0, flipCull, level.getVisStatic() );
	level.getStaticEntities().addEntity( e );
	e->getMatrix() = matrix;
	e->attach();
}

CThingEntity* CGameLevelCreator::createThingEntity(
		const std::string& name, const std::string& clazzName,
		const std::string& staticName, const SMatrix4x4& matrix )
{
	CLevel& level = CGameInfo::getInstance().getLevel();
	level.getBounds().extend( matrix.getOrigin() );
	if( clazzName == "o_marker" ) {
		level.getMarkers().setValue( name, matrix );
		return NULL;
	}
	CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( clazzName );
	assert( clazz );
	const float THING_MASS = 500.0f;
	CThingEntity* e = new CThingEntity( name, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), level.getVisThing(), THING_MASS );
	level.getThingEntities().addEntity( e );
	SMatrix4x4 m = matrix;
	m.getOrigin().y += 1.0f; // HACK
	e->getPhysComp().setMatrixPORed( m );
	e->attach();
	level.getBounds().addBoundable( e->getWorldMatrix(), e );

	return e;
}

void CGameLevelCreator::createStaticLink(
		const std::string& entity1Name, const std::string& entity2Name,
		const std::string& tag1Name, const std::string& tag2Name,
		const SVector3& tag1flips, const SVector3& tag2flips )
{
	// we aren't interested in this
}
