#ifndef __VEHICLE_H
#define __VEHICLE_H

#include "BasePhysicsEntity.h"
#include "VehicleClass.h"
#include <dingus/collider-ode/Collidable.h>
#include <dingus/physics-ode/PhysicsJointGroup.h>
#include <dingus/physics-ode/PhysicsJoint.h>
#include "../level/LevelBounds.h"


class CVehicle : public unco::CTypedNamedContainer<CBasePhysicsEntity>, public ILevelBoundListener {
public:
	CVehicle( const std::string& name, const CVehicleClass& clazz, unco::CVisibilityComponent& visComp );
	~CVehicle();

	const CVehicleClass& getClass() const { return *mClass; }

	void control( float velocity, float steering );

	void setOutOfBounds( bool outof ) { mOutOfBounds = outof; }
	bool isOutOfBounds() const { return mOutOfBounds; }

	const CBasePhysicsEntity& getBody() const { return *findEntity(CVehicleClass::BODY_NAME); }
	CBasePhysicsEntity& getBody() { return *findEntity(CVehicleClass::BODY_NAME); }
	const CBasePhysicsEntity& getWheel( int wh ) const { return *findEntity(CVehicleClass::WHEEL_NAMES[wh]); }
	CBasePhysicsEntity& getWheel( int wh ) { return *findEntity(CVehicleClass::WHEEL_NAMES[wh]); }

	virtual bool onLevelBound() {
		mOutOfBounds = true;
		return false;
	}

protected:
	virtual void internalAttach();
	virtual void internalDetach();
	virtual void internalPostAttach();
	virtual void internalPreDetach();
	virtual void internalUpdate();

private:
	const CVehicleClass*			mClass;
	dingus::CCollidableContainer*	mColContainer;
	dingus::CPhysicsJointGroup*		mJoints;
	dingus::CPhysicsJointHinge2*	mHinges[CVehicleClass::MAX_WHEELS];
	bool	mOutOfBounds;
};


#endif
