#ifndef __LEVEL_SERIALIZER_H
#define __LEVEL_SERIALIZER_H


class CThingEntity;
class ILevelCreator {
public:
	virtual ~ILevelCreator() = 0 { }

	virtual void createStaticEntity(
		const std::string& name, const std::string& clazzName,
		const SMatrix4x4& matrix, bool flipCull ) = 0;
	virtual void createStaticLink(
		const std::string& entity1Name, const std::string& entity2Name,
		const std::string& tag1Name, const std::string& tag2Name,
		const SVector3& tag1flips, const SVector3& tag2flips ) = 0;
	virtual CThingEntity* createThingEntity(
		const std::string& name, const std::string& clazzName,
		const std::string& staticName, const SMatrix4x4& matrix ) = 0;
};

class CLevelFileWriter {
public:
	CLevelFileWriter( const char* fileName );
	~CLevelFileWriter();

	void	beginStaticEntities();
	void	writeStaticEntity( const std::string& name, const std::string& clazzName,
		const SMatrix4x4& matrix, bool flipCull );
	void	endStaticEntities();

	void	beginThingEntities();
	void	writeThingEntity( const std::string& name, const std::string& clazzName,
		const std::string& staticName, const SMatrix4x4& matrix );
	void	endThingEntities();

	void	beginStaticLinks();
	void	writeStaticLink(
		const std::string& entity1Name, const std::string& entity2Name,
		const std::string& tag1Name, const std::string& tag2Name,
		const SVector3& tag1flips, const SVector3& tag2flips );
	void	endStaticLinks();

private:
	FILE*	mFile;
};

class CLevelFileReader {
public:
	static void read( const char* fileName, ILevelCreator& creator );
};

#endif
