 #include "../stdafx.h"
#pragma hdrstop

#include "FollowCameraController.h"


CFollowCameraController::CFollowCameraController( float distance, float height, float omegaSq )
:	mFollowMatrix(NULL), mAffectedMatrix(NULL), mDistance(distance), mHeight(height), mOmegaSq(omegaSq)
{
	mVelocity.set(0,0,0);
	mBeta = 2.0f * sqrtf( mOmegaSq ); // critical damping
}


void CFollowCameraController::update( float dt, const SVector3& followVelocity, bool useDir )
{
	if( !mFollowMatrix || !mAffectedMatrix )
		return;

	SVector3 a;
	
	SVector3 dir = mFollowMatrix->getAxisZ();
	dir.y = 0.0f;
	dir.normalize();

	// compute the position-dependent acceleration
	if( useDir ) {
		a = -mOmegaSq * (mAffectedMatrix->getOrigin() - (mFollowMatrix->getOrigin() - SVector3(mDistance*dir.x, -mHeight, mDistance*dir.z) ) );
	} else {
		float r = sqrtf( followVelocity.x*followVelocity.x + followVelocity.z*followVelocity.z );
		if( r > 2.5f ) { // > 2.5m/s
			a = -mOmegaSq * (mAffectedMatrix->getOrigin() - (mFollowMatrix->getOrigin() - SVector3(mDistance*followVelocity.x/r, -mHeight, mDistance*followVelocity.z/r) ) );
		} else {
			SVector3 offset = mAffectedMatrix->getOrigin() - mFollowMatrix->getOrigin();
			r = sqrtf( offset.x*offset.x + offset.z*offset.z );
			if( r > 0.001f ) { // > 1mm
				float accel = -mOmegaSq * (r - mDistance) / r;
				a.x = offset.x * accel;
				a.z = offset.z * accel;
			}
			a.y = -mOmegaSq * (offset.y - mHeight);
		}
	}

	// compute the velocity-dependent acceleration
	a -= mBeta * (mVelocity - followVelocity);

	// update by one timestep
	mVelocity += a * dt;
	mAffectedMatrix->getOrigin() += mVelocity * dt;

	mAffectedMatrix->getAxisZ() = SVector3(mFollowMatrix->getOrigin()-mAffectedMatrix->getOrigin()).getNormalized();
	mAffectedMatrix->getAxisX() = SVector3(0,1,0).cross( mAffectedMatrix->getAxisZ() );
	mAffectedMatrix->getAxisY() = mAffectedMatrix->getAxisZ().cross( mAffectedMatrix->getAxisX() );
}
