 #include "stdafx.h"
#pragma hdrstop

#include "MyEnemy.h"
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/Vehicle.h>
#include <jam/entity/ThingEntity.h>
#include <jam/entity/EntityClasses.h>
#include "MyGame.h"

using namespace std;

CMyEnemy::CMyEnemy( string const& markerName,
	const std::string& name, const std::string& className /*const CVehicleClass& clazz*/, unco::CVisibilityComponent& visComp )
:	CMyVehicle( markerName, false, name, *CGameInfo::getInstance().getClasses().getVehicleClass( className ), visComp ),
	mLogic( NULL ),
	mCanGrab( false ),
	mCapturedThing( NULL )
{
	mutateParalyzed();
}

CMyEnemy::~CMyEnemy()
{
	delete mLogic;
}

void CMyEnemy::internalUpdate()
{
	const float VEHICLE_BOUNDS	=	3.0f;

	if( !mCapturedThing )
	{
		CThingEntity* thing = CMyGame::getInstance().queryThing( *this, VEHICLE_BOUNDS );
		if( thing && mCanGrab )
		{
			grab( *thing );
		}
	}
	else
	{
		mCapturedThing->getPhysComp().getPhysicsable().setPosition(
			getMatrix().getOrigin() + getMatrix().getAxisY() * 2.0f );
	}


	if( !mLogic )
		mutateAtWill();

	mLogic->think( *this );


	CVehicle::internalUpdate();
}

void CMyEnemy::mutateAtWill()
{
	mutateWarrior();
}

void CMyEnemy::mutateWarrior()
{
	CVehicle* target = CMyGame::getInstance().queryHero( *this, 0.0f );
	if( target )
	{
		delete mLogic;
		mLogic = new CWarriorLogic( *target );
		setGrabable( true );
	}
}

void CMyEnemy::mutateThief()
{
/*	const float SEARCH_FIELD	=	100.0f;
	CThingEntity* thing = CMyGame::getInstance().queryThing( *this, SEARCH_FIELD );
	if( thing )
	{
		delete mLogic;
		mLogic = new CThiefLogic( *thing );
		setGrabable( true );
	}
	else
		mutateWarrior();*/

	delete mLogic;
	mLogic = new CThief2Logic();
	setGrabable( true );
}

void CMyEnemy::mutateRunaway()
{
	delete mLogic;
	mLogic = new CRunawayLogic();
	setGrabable( false );
}

void CMyEnemy::mutateParalyzed()
{
	delete mLogic;
	mLogic = new CParalyzedLogic();
	setGrabable( false );
}

void CMyEnemy::onCollide( CMyVehicle& other )
{
	if( other.isHero() )
		drop();
}

void CMyEnemy::grab( CThingEntity& thing )
{
	CMyGame::getInstance().onThingTaken( thing );
	mCapturedThing = &thing;
	mutateRunaway();
}

void CMyEnemy::drop()
{
	if( !mCapturedThing )
		return;

	CMyGame::getInstance().onThingDropped( *mCapturedThing );
	mCapturedThing = NULL;
	mutateParalyzed();
}

void CMyEnemy::score()
{
	if( !mCapturedThing )
		return;

	CMyGame::getInstance().onThingTheft( *mCapturedThing );
	mCapturedThing = NULL;
	mutateAtWill();
}



CWarriorLogic::CWarriorLogic( CVehicle const& target )
:	mTarget( target )
{
}

void CWarriorLogic::think( CMyEnemy& self )
{
	SVector3 delta = mTarget.getMatrix().getOrigin() - self.getMatrix().getOrigin();
	float dot = delta.dot( self.getMatrix().getAxisX() );
	float dot2 = delta.dot( self.getMatrix().getAxisZ() );

	float a = 0.0f;
	float t = 0.0f;
	if( dot < -0.3f )
		t += 1.0f;
	if( dot > 0.3f )
		t -= 1.0f;

	if( delta.length() > 5.0f )
		a += 1.0f;

	if( delta.length() < 5.0f )
	{
		t = 0.0f;
		a -= 3.0f;
	}

	if( delta.length() > 5.0f && dot2 < 0 )
	{
		a -= 3.0f;
		t *= -1.0f;
	}

	self.control( a, t );


/*	const float SEARCH_FIELD	=	100.0f;
	if( delta.length() > SEARCH_FIELD )
		self.mutateThief();*/
}

CAvoidingRunLogic::CAvoidingRunLogic( float acceleration, float turn )
:	mAvoidAcceleration( acceleration ), mAvoidTurn( turn )
{
}

void CAvoidingRunLogic::think( CMyEnemy& self, float a, float t )
{
	if( mThinksUntilNextCheck-- <= 0 )
	{
		mThinksUntilNextCheck = 200;

		SVector3 distance = mCheckPoint - self.getMatrix().getOrigin();
		if( distance.length() < 1.2f )
		{
			mAvoidAcceleration *= -1.0f;
			mAvoidTurn *= -1.0f;
			mThinksUntilNextCheck = 400;
		}
		else
		{
			if( mAvoidAcceleration < 0.0f )
				mAvoidAcceleration *= -1.0f;

			if( mAvoidTurn < 0.0f )
				mAvoidTurn *= -1.0f;
		}
		mCheckPoint = self.getMatrix().getOrigin();

	}

	a *= mAvoidAcceleration;
	t *= mAvoidTurn;

	self.control( a, t );
}

CThiefLogic::CThiefLogic( CThingEntity& target )
:	mTarget( target )
{
}

void CThiefLogic::think( CMyEnemy& self )
{
	SVector3 delta = mTarget.getMatrix().getOrigin() - self.getMatrix().getOrigin();
	float dot = delta.dot( self.getMatrix().getAxisX() );
	float dot2 = delta.dot( self.getMatrix().getAxisZ() );

	float a = 0.0f;
	float t = 0.0f;
	if( dot < -0.1f )
		t += 1.0f;
	if( dot > 0.1f )
		t -= 1.0f;

	a += 1.0f;

	self.control( a, t );
}

void CThief2Logic::think( CMyEnemy& self )
{
	const float SEARCH_FIELD	=	250.0f;
	CThingEntity* thing = CMyGame::getInstance().queryThing( self, SEARCH_FIELD );

	if( !thing )
	{
		self.mutateAtWill();
		return;
	}

	SVector3 delta = thing->getMatrix().getOrigin() - self.getMatrix().getOrigin();
	float dot = delta.dot( self.getMatrix().getAxisX() );
	float dot2 = delta.dot( self.getMatrix().getAxisZ() );

	float a = 0.0f;
	float t = 0.0f;
	if( dot < -0.1f )
		t += 1.0f;
	if( dot > 0.1f )
		t -= 1.0f;

	a += 1.0f;

//	self.control( a, t );
	mAvoidingRun.think( self, a, t );
}


void CRunawayLogic::think( CMyEnemy& self )
{
	const SMatrix4x4& markM = CGameInfo::getInstance().getLevel().getMarkers().getValue( self.getMarkerName() );
	
	SVector3 delta = markM.getOrigin() - self.getMatrix().getOrigin();
	float dot = delta.dot( self.getMatrix().getAxisX() );
	float dot2 = delta.dot( self.getMatrix().getAxisZ() );

	float a = 0.0f;
	float t = 0.0f;
	if( dot < -0.3f )
		t += 0.3f;
	if( dot > 0.3f )
		t -= 0.3f;

	if( delta.length() > 3.0f )
		a += 0.3f;

	if( delta.length() > 5.0f && dot2 < 0 )
	{
		a -= 1.0f;
		t *= -1.0f;
	}

//	self.control( a, t );
	mAvoidingRun.think( self, a, t );


	if( delta.length() < 3.0f )
		self.score();
}

CParalyzedLogic::CParalyzedLogic()
:	mThinksLeft( 200 * 10 )
{
}

void CParalyzedLogic::think( CMyEnemy& self )
{
	mThinksLeft--;
	self.control( 0.0f, 0.0f );

	if( mThinksLeft <= 0 )
		self.mutateAtWill();
}

