#ifndef __MY_ENEMY_H
#define __MY_ENEMY_H

#include "MyVehicle.h"


class CThingEntity;
class IEnemyLogic;

class CMyEnemy : public CMyVehicle
{
public:
	CMyEnemy(
		const std::string& markerName,
		const std::string& name, const std::string& className, unco::CVisibilityComponent& visComp );
	virtual ~CMyEnemy();

	virtual void mutateAtWill();
	virtual void mutateWarrior();
	virtual void mutateThief();
	virtual void mutateRunaway();
	virtual void mutateParalyzed();

	virtual void onCollide( CMyVehicle& other );

	virtual bool onLevelBound() {
		mCapturedThing = NULL;

		return CVehicle::onLevelBound();
	}

	void score();
	void setGrabable( bool grab = true ) { mCanGrab = grab; }

protected:
	virtual void internalUpdate();

	void grab( CThingEntity& thing );
	void drop();

private:
	IEnemyLogic*		mLogic;
	bool				mCanGrab;
	CThingEntity*		mCapturedThing;
};


class CMyEnemy1 : public CMyEnemy
{
public:
	CMyEnemy1(
		const std::string& markerName,
		const std::string& name, unco::CVisibilityComponent& visComp )
		: CMyEnemy( markerName, name, "monster", visComp ) {}

	virtual void mutateAtWill() { mutateWarrior(); }
	virtual void mutateWarrior() { CMyEnemy::mutateWarrior(); setGrabable( false ); }
	virtual void mutateThief() { mutateWarrior(); }
	virtual void mutateRunaway() { mutateWarrior(); }
	virtual void mutateParalyzed() { mutateWarrior(); }
};

class CMyEnemy2 : public CMyEnemy
{
public:
	CMyEnemy2(
		const std::string& markerName,
		const std::string& name, unco::CVisibilityComponent& visComp )
		: CMyEnemy( markerName, name, "goom", visComp ) {}

	virtual void mutateAtWill() { mutateThief(); }
	virtual void mutateWarrior() { mutateThief(); }
};

class CMyEnemy3 : public CMyEnemy
{
public:
	CMyEnemy3(
		const std::string& markerName,
		const std::string& name, unco::CVisibilityComponent& visComp )
		: CMyEnemy( markerName, name, "goom", visComp ) {}
};


class IEnemyLogic
{
public:
	virtual ~IEnemyLogic() = 0 {};

	virtual void think( CMyEnemy& self ) = 0;
};

class CWarriorLogic : public IEnemyLogic
{
public:
	CWarriorLogic( CVehicle const& target );
	virtual void think( CMyEnemy& self );

private:
	CVehicle const&		mTarget;
};

class CAvoidingRunLogic
{
public:
	CAvoidingRunLogic( float acceleration = 1.0f, float turn = 1.0f );
	virtual void think( CMyEnemy& self, float a, float t );

private:
	SVector3	mCheckPoint;
	int			mThinksUntilNextCheck;

	float		mAvoidAcceleration;
	float		mAvoidTurn;
};

class CThiefLogic : public IEnemyLogic
{
public:
	CThiefLogic( CThingEntity& target );
	virtual void think( CMyEnemy& self );

private:
	CThingEntity const&		mTarget;
};

class CThief2Logic : public IEnemyLogic
{
public:
	virtual void think( CMyEnemy& self );

private:
	CAvoidingRunLogic		mAvoidingRun;
};

class CRunawayLogic : public IEnemyLogic
{
public:
	virtual void think( CMyEnemy& self );

private:
	CAvoidingRunLogic		mAvoidingRun;
};

class CParalyzedLogic : public IEnemyLogic
{
public:
	CParalyzedLogic();
	virtual void think( CMyEnemy& self );

private:
	int	mThinksLeft;
};


#endif
