#include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <string>
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/ThingEntity.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>

#include "MyEnemy.h"
#include "MyVehicle.h"

using namespace std;

CMyGame::CMyGame()
{
//	mFollowCamera[0] = new CFollowCameraController( 7.0f, 2.0f, 30.0f );
	mFollowCamera[0] = new CFollowCameraController( 7.0f, 1.5f, 30.0f );
	mFollowCamera[1] = new CFollowCameraController( -12.0f, 1.0f, 50.0f );

	mHoldOnText = NULL;
	mGameOverText = NULL;
}

CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	// things
	const std::string THING_CLASS_NAME = "o_cone";

	for( CLevel::TBaseEntityContainer::TEntityMap::iterator e = level.getThingEntities().getEntities().begin();
		e != level.getThingEntities().getEntities().end(); ++e )
	{
		if( e->second->getClass().getName() == THING_CLASS_NAME )
		{
			onThingDropped( *(CThingEntity*)e->second.get() );
			mThingsLeft++;
		}
	}

	// vehicles
	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = i ? "monster" : "goom";

		if( i == 0 )
			mVehicle[i] = new CMyHero( "start1", "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		else
			mVehicle[i] = new CMyEnemy2( "start2",
				"test", /**CGameInfo::getInstance().getClasses().getVehicleClass(name), */level.getVisStuff() );

		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[0]->getWorldMatrix() );
	}


	string markers[ENEMY_MARKERS] = { "start3", "start4", "start5", "start6" };
//	,	"start3", "start4", "start5", "start6"
//	,	"start3", "start4", "start5", "start6" };

	for( i = 0; i < ENEMY_MARKERS; ++i )
	{
		if( i == 0 )
		{
			mEnemies[i] = new CMyEnemy2( markers[i],
				"test", level.getVisStuff() );
		}
		else
		{
			mEnemies[i] = new CMyEnemy1( markers[i],
				"test", level.getVisStuff() );
		}

		const SMatrix4x4& markM = level.getMarkers().getValue( markers[i] );
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;

		level.getStuff().addEntity( mEnemies[i] );
		mEnemies[i]->getMatrix() = carm;
		mEnemies[i]->attach();
		level.getBounds().addBoundable( mEnemies[i]->getWorldMatrix(), mEnemies[i] );
	}
	mEnemiesCount = ENEMY_MARKERS;
}

void CMyGame::onInitialize()
{
	mThings.clear();
	mThingsLeft = 0;

//	createLevel( "../data/script/levels/test03.lua" );
	createLevel( "../data/script/levels/fight01.lua" );

	mTimer = 5.0f * 60.0f;
}

void CMyGame::onBeginCycle()
{
	float height, width;
	char buf[100];

	sprintf( buf, "cash: %i", mVehicle[0]->getCash() );
	height = 0.06f;
	width = getTextRenderer().getWidth( buf, height );
	mScoreText = getTextRenderer().renderTextHeight( buf,
		SVector2(0.95f-width,1-height), height, 0xFFFFFFFF
	);

	sprintf( buf, "artifacts: %i  captured: %i", mThingsLeft, mThingsLeft-mThings.size() );
	height = 0.06f;
	width = getTextRenderer().getWidth( buf, height );
	mThingsText = getTextRenderer().renderTextHeight( buf,
		SVector2(-0.95f,1-height), height, 0xFFFFFFFF
	);

	if( mThingsLeft )
		mTimer -= CSystemClock::getInstance().getLastPerformDuration();

	if( mTimer < 0.0f )
		mTimer = 0.0f;

	sprintf( buf, "time left: %i", (int)mTimer );
	height = 0.08f;
	width = getTextRenderer().getWidth( buf, height );
	mTimerText = getTextRenderer().renderTextHeight( buf,
		SVector2(0.98f-width,-1.0), height, 0xFFFFFFFF
	);

	string markers[ENEMIES] = { "start3", "start4", "start5", "start6"
	};


	float t = 90;
	if( mTimer < t && mEnemiesCount < ENEMIES )
	{
		CLevel& level = CGameInfo::getInstance().getLevel();
		for( int i = 0; i < ENEMIES - ENEMY_MARKERS; ++i )
		{
			int m = ENEMY_MARKERS + i;
			mEnemies[m] = new CMyEnemy2( markers[i+1],
				"test", level.getVisStuff() );

			const SMatrix4x4& markM = level.getMarkers().getValue( markers[i+1] );
			SMatrix4x4 carm = markM;
			carm.getOrigin().y += 1.0f;

			level.getStuff().addEntity( mEnemies[m] );
			mEnemies[m]->getMatrix() = carm;
			mEnemies[m]->attach();
			level.getBounds().addBoundable( mEnemies[m]->getWorldMatrix(), mEnemies[m] );
		}
		mEnemiesCount = ENEMIES;
	}

	if( mTimer < t && mTimer > t - 10 && mThingsLeft )
	{
		float height = 0.25f;
		std::string holdOn = "Hold On";
		float width = getTextRenderer().getWidth( holdOn, height );
		mHoldOnText = getTextRenderer().renderTextHeight( holdOn,
			SVector2(-width/2.0f,-0.5f-height/2.0f), height, 0xFFFFFFFF );
	}


	if( mTimer <= 0.0f )
	{
		float height = 0.25f;
		std::string winner = "You Win!!!";
		float width = getTextRenderer().getWidth( winner, height );
		mGameOverText = getTextRenderer().renderTextHeight( winner,
			SVector2(-width/2.0f,-0.5f-height/2.0f), height, 0xFFFFFFFF );
	}
	else if( !mThingsLeft )
	{

		float height = 0.25f;
		std::string gameOver = "You Loose";
		float width = getTextRenderer().getWidth( gameOver, height );
		mGameOverText = getTextRenderer().renderTextHeight( gameOver,
			SVector2(-width/2.0f,-0.5f-height/2.0f), height, 0xFFFFFFFF );
	}
}

void CMyGame::onEndCycle()
{
	delete mScoreText;
	delete mThingsText;
	delete mTimerText;

	delete mHoldOnText; mHoldOnText = NULL;
	delete mGameOverText; mGameOverText = NULL;
}

void CMyGame::onUpdate()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( 1/200.0f, SVector3(0,0,0), true );
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			continue;
		}
	}

	for( i = 0; i < mEnemiesCount; ++i ) {
		if( mEnemies[i]->isOutOfBounds() ) {
			mEnemies[i]->detach();
			mEnemies[i]->setOutOfBounds( false );
			mEnemies[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue( mEnemies[i]->getMarkerName() );
			mEnemies[i]->getMatrix().getOrigin().y += 1.0f;
			mEnemies[i]->attach();
			continue;
		}
	}


	if( mThingsLeft && mTimer > 0.0f )
	{
		for( i = 0; i < VEHICLES; ++i )	
			mVehicle[i]->onControl();
	}


	static n = 0;
	if( n++ % 100 == 0 )
	{
		for( i = 0; i < VEHICLES; ++i )
		{
			mVehicle[i]->updateCash( mThings.size() );
		}
	}



	CGameInfo::getInstance().getLevel().update();
}

void CMyGame::onThingTaken( CThingEntity& thing )
{
	mThings.remove( &thing );
}

void CMyGame::onThingDropped( CThingEntity& thing )
{
	mThings.push_back( &thing );
	thing.getPhysComp().getPhysicsable().enable();
	thing.getPhysComp().getPhysicsable().setLinearVel( SVector3( 0.0f, 3.0f, 0.0f ) );
}

void CMyGame::onThingTheft( CThingEntity& thing )
{
	CGameInfo::getInstance().getLevel().getBounds().removeBoundable( thing.getWorldMatrix() );
	thing.detach();
	thing.discard();

	mThingsLeft--;
}

CMyVehicle* CMyGame::queryHero( CVehicle const& vehicle, float radius )
{
	return mVehicle[0];
}

CThingEntity* CMyGame::queryThing( CVehicle const& vehicle, float radius )
{
	const float THING_BOUNDS = 1.0f;

	TThingList::iterator nearest = mThings.end();
	for( TThingList::iterator i = mThings.begin(); i != mThings.end(); ++i )
	{
		assert( *i );

		SVector3 delta = vehicle.getMatrix().getOrigin() - (*i)->getMatrix().getOrigin();
		if( delta.length() <= radius + THING_BOUNDS )
		{
			if( nearest != mThings.end() )
			{
				assert( *nearest );
				SVector3 deltaToNearest = vehicle.getMatrix().getOrigin() - (*nearest)->getMatrix().getOrigin();
				if( delta.lengthSq() > deltaToNearest.lengthSq() )
					continue;
			}

			nearest = i;
		}
	}

	if( nearest == mThings.end() )
		return NULL;

	return nearest->get();
}
