#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
#include <jam/BaseGame.h>
#include <jam/utils/FollowCameraController.h>
#include <jam/entity/Vehicle.h>


class CMyEnemy;
class CMyVehicle;
class CThingEntity;

class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame> {
public:
	enum { VEHICLES = 2 };
	enum { ENEMY_MARKERS = 4 };
	enum { ENEMIES = 6 };


public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

	CMyVehicle* queryHero( CVehicle const& vehicle, float radius );
	CThingEntity* queryThing( CVehicle const& vehicle, float radius );

	void onThingTaken( CThingEntity& thing );
	void onThingDropped( CThingEntity& thing );
	void onThingTheft( CThingEntity& thing );

private:
	void	createLevel( const std::string& name );
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;

private:
	CFollowCameraController*		mFollowCamera[VEHICLES];
	CMyVehicle*						mVehicle[VEHICLES];
	CTextRenderer::CRenderedText*	mScoreText;
	CTextRenderer::CRenderedText*	mThingsText;
	CTextRenderer::CRenderedText*	mHoldOnText;
	CTextRenderer::CRenderedText*	mGameOverText;

	CMyEnemy*						mEnemies[ENEMIES];
	int								mEnemiesCount;

	typedef boost::intrusive_ptr<CThingEntity>	TEntityPtr;
	typedef std::list<TEntityPtr>				TThingList;
	TThingList						mThings;
	int								mThingsLeft;

	unco::CTextRenderer::CRenderedText*	mTimerText;
	float							mTimer;
};


#endif
