 #include "stdafx.h"
#pragma hdrstop

#include "MyVehicle.h"
#include <jam/GameLevelCreator.h>
#include <jam/entity/ThingEntity.h>
#include <jam/level/Level.h>
#include <jam/level/GameInfo.h>

#include "MyGame.h"

using namespace std;

CMyVehicle::CMyVehicle( string const& markerName, bool hero,
	const std::string& name, const CVehicleClass& clazz, unco::CVisibilityComponent& visComp )
:	CVehicle( name, clazz, visComp ),
	mMarkerName( markerName ),
	mHero( hero )
{
}

CMyVehicle::~CMyVehicle()
{
}


CMyHero::CMyHero( string const& markerName,
	const std::string& name, const CVehicleClass& clazz, unco::CVisibilityComponent& visComp )
:	CMyVehicle( markerName, true, name, clazz, visComp ),
	mCash( 100 )
{
	mLastFireTime = CSystemClock::getInstance().getTime();
	mLastSwitchTime = CSystemClock::getInstance().getTime();

	mWeapons.push_back( new CFire1_10() );
	mWeapons.push_back( new CFire2() );
	mWeapons.push_back( new CFire3() );

	mFire = mWeapons.begin();
}

CMyHero::~CMyHero()
{
}

void CMyHero::nextWeapon()
{
	assert( *mFire );
	(*mFire)->end();

	mFire++;
	if( mFire == mWeapons.end() )
		mFire = mWeapons.begin();

	(*mFire)->begin();
}

void CMyHero::internalUpdate()
{
	const float VEHICLE_BOUNDS	=	2.0f;
	CThingEntity* thing = CMyGame::getInstance().queryThing( *this, VEHICLE_BOUNDS );
	if( thing )
	{
		SVector3 delta = getMatrix().getAxisZ();
		delta.y = 0.0f;
		delta.normalize();
		thing->getPhysComp().getPhysicsable().setLinearVel( delta * 10.0f );
	}

	assert( *mFire );
	(*mFire)->visualice( *this );

	CMyVehicle::internalUpdate();
}

void CMyHero::onControl()
{
	double t = CSystemClock::getInstance().getTime();

	int keyUp = VK_UP;
	int keyDown = VK_DOWN;
	int keyLeft = VK_LEFT;
	int keyRight= VK_RIGHT;
	int keyFire = VK_CONTROL;
	int keyNextFire = VK_SPACE;



	float accel = 0.0f;
	if( GetAsyncKeyState(keyUp) )
		accel += 1.0;
	if( GetAsyncKeyState(keyDown) )
		accel -= 1.0;

	float turn = 0.0f;
	if( GetAsyncKeyState(keyLeft) )
		turn += 1.5;
	if( GetAsyncKeyState(keyRight) )
		turn -= 1.5;

	control( accel, turn );

	if( GetAsyncKeyState(keyNextFire) && t > mLastSwitchTime + 0.2f )
	{
		nextWeapon();
		mLastSwitchTime = t;
	}

	if( GetAsyncKeyState(keyFire) && t > mLastFireTime + 0.2f )
	{
		assert( *mFire );
		(*mFire)->fire( *this );
		mLastFireTime = t;
	}
}


CAbstractFireLogic::CAbstractFireLogic( std::string const& name, std::string const& clazzName )
{
	SMatrix4x4 m;
	m.identify();

	CGameLevelCreator creator;
	mIcon = creator.createThingEntity( name, clazzName, "", m );
}

void CAbstractFireLogic::begin()
{
	if( !mIcon->isAttached() )
		mIcon->attach();
}

void CAbstractFireLogic::visualice( CMyHero& hero )
{
	mIcon->getPhysComp().getPhysicsable().setPosition(
		hero.getMatrix().getOrigin() + hero.getMatrix().getAxisY() * 3.0f );

	mIcon->getPhysComp().getPhysicsable().disable();
}

void CAbstractFireLogic::end()
{
	mIcon->detach();
}


CFire1::CFire1()
:	CAbstractFireLogic( "fire1", "Sphere" )
{
}

void CFire1::fire( CMyHero& hero )
{
	const int PRICE = 1;
	if( hero.getCash() < PRICE )
		return;
	hero.updateCash( -PRICE );


	char buf[200];
	static int n = 0;
	sprintf( buf, "fire1_%i", n++ );

	SMatrix4x4 m = hero.getMatrix();
	m.getOrigin() += m.getAxisZ() * 1.0f;

	CGameLevelCreator creator;
	CThingEntity* e = creator.createThingEntity( buf, "Sphere", "", m );
	assert( e );

	SVector3 vel = hero.getBody().getPhysComp().getPhysicsable().getLinearVel();
	e->getPhysComp().getPhysicsable().setLinearVel( m.getAxisZ() * 20.0f + vel );
}

CFire1_10::CFire1_10()
:	CAbstractFireLogic( "fire1_10", "Sphere" )
{
}

void CFire1_10::fire( CMyHero& hero )
{
	const int PRICE = 1;
	if( hero.getCash() < PRICE )
		return;
	hero.updateCash( -PRICE );


	char buf[200];
	static int n = 0;
	sprintf( buf, "fire1_10%i", n++ );

	SMatrix4x4 m = hero.getMatrix();
	m.getOrigin() += m.getAxisZ() * 1.0f;

	CGameLevelCreator creator;
	CThingEntity* e = creator.createThingEntity( buf, "Sphere", "", m );
	assert( e );

	mProjectiles.push_back( e );

	SVector3 vel = hero.getBody().getPhysComp().getPhysicsable().getLinearVel();
	e->getPhysComp().getPhysicsable().setLinearVel( m.getAxisZ() * 20.0f + vel );

	if( mProjectiles.size() > 10 )
	{
		TEntityPtr old = *mProjectiles.begin();
		assert( old );


		CLevel& level = CGameInfo::getInstance().getLevel();
		level.getBounds().removeBoundable( old->getWorldMatrix() );

		if( !old->isDiscarded() && old->isAttached() )
			old->detach();

		if( !old->isDiscarded() )
			old->discard();
		
		mProjectiles.pop_front();
	}
}

CFire2::CFire2()
:	CAbstractFireLogic( "fire2", "o_sign" )
{
}

void CFire2::fire( CMyHero& hero )
{
	const int PRICE = 10;
	if( hero.getCash() < PRICE )
		return;
	hero.updateCash( -PRICE );


	char buf[200];
	static int n = 0;
	sprintf( buf, "fire2_%i", n++ );

	SMatrix4x4 m = hero.getMatrix();
	m.getOrigin() -= m.getAxisZ() * 3.0f;


	D3DXQUATERNION q;
	D3DXQuaternionRotationYawPitchRoll( &q, 3.14f / 2.0f, 0.0f, 0.0f );
	SMatrix4x4 rm;
	rm.rotationQuat( q );

	CGameLevelCreator creator;
	creator.createThingEntity( buf, "o_sign", "", rm * m );
}

CFire3::CFire3()
:	CAbstractFireLogic( "fire3", "Barrel" )
{
}

void CFire3::fire( CMyHero& hero )
{
	const int PRICE = 5;
	if( hero.getCash() < PRICE )
		return;
	hero.updateCash( -PRICE );

	
	char buf[200];
	static int n = 0;
	sprintf( buf, "fire3_%i", n++ );

	SMatrix4x4 m = hero.getMatrix();
	m.getOrigin() -= m.getAxisZ() * 2.0f;

	CGameLevelCreator creator;
	creator.createThingEntity( buf, "Barrel", "", m );
}

