#ifndef __MY_VEHICLE_H
#define __MY_VEHICLE_H

//#include <jam/entity/Vehicle.h>
#include "../../jam/jam/entity/Vehicle.h"


class CMyVehicle : public CVehicle
{
public:
	CMyVehicle(
		const std::string& markerName, bool hero,
		const std::string& name, const CVehicleClass& clazz, unco::CVisibilityComponent& visComp );
	virtual ~CMyVehicle();

	virtual void onControl() {}
	virtual void onCollide( CMyVehicle& other ) {}
	
	std::string getMarkerName() const { return mMarkerName; }
	bool isHero() const { return mHero; }

	virtual void updateCash( int cash ) {}
	virtual int getCash() const { return 0; }

private:
	std::string const	mMarkerName;
	bool				mHero;
};


class IFireLogic;
class CMyHero : public CMyVehicle
{
public:
	CMyHero(
		const std::string& markerName,
		const std::string& name, const CVehicleClass& clazz, unco::CVisibilityComponent& visComp );
	virtual ~CMyHero();

	virtual void onControl();
	
	void updateCash( int cash ) { mCash += cash; }
	int getCash() const { return mCash; }

protected:
	virtual void internalUpdate();

	void nextWeapon();

private:
//	IFireLogic*	mFire;
	typedef	std::list<IFireLogic*>	TWeapons;
	TWeapons			mWeapons;
	TWeapons::iterator	mFire;

	float				mLastFireTime;
	float				mLastSwitchTime;

	int					mCash;
};

class IFireLogic
{
public:
	virtual ~IFireLogic() = 0 {}

	virtual void begin() = 0;
	virtual void visualice( CMyHero& hero ) = 0;
	virtual void end() = 0;

	virtual void fire( CMyHero& hero ) = 0;
};

class CThingEntity;
class CAbstractFireLogic : public IFireLogic
{
public: 
	CAbstractFireLogic( std::string const& name,std::string const& clazzName );
	virtual ~CAbstractFireLogic() {}

	virtual void begin();
	virtual void end();
	virtual void visualice( CMyHero& hero );

private:
	typedef boost::intrusive_ptr<CThingEntity>	TEntityPtr;
	TEntityPtr	mIcon;
};

class CFire1 : public CAbstractFireLogic //IFireLogic
{
public:
	CFire1();
	virtual ~CFire1() {}

	virtual void fire( CMyHero& hero );
};

class CFire1_10 : public CAbstractFireLogic //IFireLogic
{
public:
	CFire1_10();
	virtual ~CFire1_10() {}

	virtual void fire( CMyHero& hero );

private:

	typedef boost::intrusive_ptr<CThingEntity>	TEntityPtr;
	typedef std::list<TEntityPtr>				TThingList;
	TThingList				mProjectiles;
	TThingList::iterator	mCurrentProjectile;
};


class CFire2 : public CAbstractFireLogic //IFireLogic
{
public:
	CFire2();
	virtual ~CFire2() {}

	virtual void fire( CMyHero& hero );
};

class CFire3 : public CAbstractFireLogic //IFireLogic
{
public:
	CFire3();
	virtual ~CFire3() {}

	virtual void fire( CMyHero& hero );
};


#endif
