#ifndef __AMMO_ENTITY_H
#define __AMMO_ENTITY_H

#include "ThingEntity.h"


class CAmmoEntity : public CThingEntity {
public:
	CAmmoEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp, float mass )
		: CThingEntity( name, clazz, colBits, visComp, mass ), mShouldDie(false) { }

	void die() { mShouldDie = true; }

	virtual void internalUpdate() {
		if( mShouldDie ) {
			detach();
			discard();
		}
	}

private:
	bool mShouldDie;
};


#endif
