#include "../stdafx.h"
#pragma hdrstop

#include "ExplosionEntity.h"
#include "CollideClasses.h"
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/collider-ode/Collidable.h>
#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/TextureBundle.h>


using namespace dingus;

CExplosionEntity::CExplosionEntity( const std::string& name, const dingus::SVector3& pos,
		unco::CVisibilityComponent& visComp, float power )
:	CNamedEntity(name),
	mPower(power),
	mColor(0x40808080),
	mVisComp( &visComp ),
	mCounter(0)
{
	mIdentity.identify();

	getMatrix().getOrigin() = pos;
	/*
	mMesh = new unco::CMeshComponent(
		*dingus::CMeshBundle::getInstance().getResourceById( "Sphere.x" ),
		0,
		"texturedAlpha.fx",
		1,
		getWorldMatrix()
	);
	dingus::CEffectParams& params = mMesh->getParams();
	params.addTexture( "tBase", *dingus::CTextureBundle::getInstance().getResourceById( "roadSide01.png" ) );
	params.addColor4Ref( "vColor", mColor );
	addComponent( *mMesh );*/
	//mVisComp->addListener( *mMesh );


	//mPPComposite = new TPPComposite();
	mPPAnim = new TPPAnim();
	mPPAnim->addKey( TParticle::SState(0x40FFA020,5.0f,0.0f) );
	mPPAnim->addKey( TParticle::SState(0x60FF8010,3.5f,3.0f) );
	mPPAnim->addKey( TParticle::SState(0x10A0A0A0,1.5f,1.0f) );
	//mPPRepulsion = new TPPRepulsion( pos, 10.0f );
	//mPPComposite->addPhysics( *mPPAnim );
	mRenderer = new TParticleRenderer();
	mParticles = new TParticleComp( *mPPAnim, *mRenderer,
		*dingus::CIndexBufferBundle::getInstance().getResourceById("ibQuads"),
		"particleColor.fx", 2, mIdentity
	);
	mParticles->getParams().addTexture( "tBase",
		*dingus::CTextureBundle::getInstance().getResourceById("spark.png")
		);
	addComponent( *mParticles );
	mVisComp->addListener( *mParticles );

	mColSphere = new unco::CColSphereComponent( getWorldMatrix(), NULL );
	mColSphere->setRadius( 2.0f );
	addComponent( *mColSphere );
	mColSphere->getCollidable().setUserData( this );
	mColSphere->getCollidable().setCategoryBits( 1<<COL_ENTITY_STATIC );
	mColSphere->getCollidable().setCollideBits( 1<<COL_ENTITY_THING );
}

CExplosionEntity::~CExplosionEntity()
{
	//mVisComp->removeListener( *mMesh );
	mVisComp->removeListener( *mParticles );
}


void CExplosionEntity::internalUpdate()
{
	int lifetime = 300;
	float alpha = (float)mCounter / lifetime;
	float size = alpha<0.3f ? (alpha/0.3)*0.6f : (1-alpha)/0.7f*0.6f;

	for( int i = 0; i < 3; ++i ) {
		dingus::SVector3 pos = getMatrix().getOrigin();
		pos.x += dingus::random( -0.2f, 0.2f );
		pos.y += dingus::random( 0.4f );
		pos.z += dingus::random( -0.2f, 0.2f );
		dingus::SVector3 vel;
		vel.x = dingus::random(-4.4f,4.4f);
		vel.y = dingus::random(-1.2f,4.4f);
		vel.z = dingus::random(-4.4f,4.4f);
		mParticles->getParticleSystem().addParticle(
			TParticle( pos, vel, 0xFFFFFFFF, 2.0f*size, 0.0f, 1.0f )
		);
	};

	mColor.a = size;
	getMatrix().getAxisX().normalize();
	getMatrix().getAxisY().normalize();
	getMatrix().getAxisZ().normalize();
	getMatrix().getAxisX() *= (size+0.1f) * 10.0f;
	getMatrix().getAxisY() *= (size+0.1f) * 10.0f;
	getMatrix().getAxisZ() *= (size+0.1f) * 10.0f;
	mColSphere->setRadius( 0.5f + size*mPower );
	++mCounter;
	if( mCounter > lifetime ) {
		detach();
		discard();
	}
}
