#include "../stdafx.h"
#pragma hdrstop

#include "MissileEntity.h"
#include "CollideClasses.h"
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/collider-ode/Collidable.h>
#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/TextureBundle.h>


using namespace dingus;

CMissileEntity::CMissileEntity( const std::string& name, const CEntityClass& clazz,
		int colBits, unco::CVisibilityComponent& visComp, float mass, float power, int owner, bool grenade )
:	CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_MISSILE, colBits, false, visComp, mass ),
	mPower(power), mOwner(owner), mShouldExplode(false), mGrenade(grenade), mCounter(0)
{
	mIdentity.identify();

	//mPPComposite = new TPPComposite();
	mPPAnim = new TPPAnim();
	mPPAnim->addKey( TParticle::SState(0x00FFFFFF,0.2f,0.0f) );
	mPPAnim->addKey( TParticle::SState(0x10FFFFFF,0.6f,1.0f) );
	mPPAnim->addKey( TParticle::SState(0x00FFFFFF,0.8f,2.0f) );
	//mPPRepulsion = new TPPRepulsion( pos, 10.0f );
	//mPPComposite->addPhysics( *mPPAnim );
	mRenderer = new TParticleRenderer();
	mParticles = new TParticleComp( *mPPAnim, *mRenderer,
		*dingus::CIndexBufferBundle::getInstance().getResourceById("ibQuads"),
		"particleColor.fx", 2, mIdentity
	);
	mParticles->getParams().addTexture( "tBase",
		*dingus::CTextureBundle::getInstance().getResourceById("smoke.png")
		);
	addComponent( *mParticles );
	getVisComp().addListener( *mParticles );
}

CMissileEntity::~CMissileEntity()
{
	getVisComp().removeListener( *mParticles );
}

void CMissileEntity::internalUpdate()
{
	const int GRENADE_LIFE = 200*5;
	if( mGrenade && mCounter++ > GRENADE_LIFE )
		mShouldExplode = true;

	if( mShouldExplode ) {
		detach();
		discard();
		CLevel& level = CGameInfo::getInstance().getLevel();
		level.getBounds().removeBoundable( getWorldMatrix() );
		CExplosionEntity* e = new CExplosionEntity( "foo!", getMatrix().getOrigin(), level.getVisStuff(), mPower );
		level.getStuff().addEntity( e );
		e->attach();
		return;
	}

	dingus::SVector3 pos = getMatrix().getOrigin();
	pos.x += dingus::random( -0.3f, 0.3f );
	pos.z += dingus::random( -0.3f, 0.3f );
	dingus::SVector3 vel;
	vel.x = dingus::random(-0.6f,0.6f);
	vel.y = dingus::random(0.6f,1.6f);
	vel.z = dingus::random(-0.6f,0.6f);
	mParticles->getParticleSystem().addParticle(
		TParticle( pos, vel, 0x00FFFFFF, 2.0f, 0.0f, 2.0f )
	);
}
