#ifndef __MISSILE_ENTITY_H
#define __MISSILE_ENTITY_H

#include "BasePhysicsEntity.h"
#include "CollideClasses.h"
#include "ExplosionEntity.h"
#include "../level/GameInfo.h"
#include "../level/Level.h"
#include <unco/component/gfx/ParticlesComponent.h>
#include <dingus/gfx/particles/Particle.h>
#include <dingus/gfx/particles/ParticlePhysics.h>
#include <dingus/gfx/particles/ParticlePhysicses.h>


class CMissileEntity : public CBasePhysicsEntity {
public:
	CMissileEntity( const std::string& name, const CEntityClass& clazz,
		int colBits, unco::CVisibilityComponent& visComp, float mass, float power, int owner, bool grenade );
	~CMissileEntity();

	bool isGrenade() const { return mGrenade; }

	float	getPower() const { return mPower; }
	int		getOwner() const { return mOwner; }

	void	explode() { mShouldExplode = true; }

protected:
	void internalUpdate();

	typedef dingus::CSizedRotColoredParticle		TParticle;
	typedef unco::CParticlesComponent<TParticle>	TParticleComp;
	typedef dingus::CVBSizedRotColoredParticleRenderer<TParticle> TParticleRenderer;
	//typedef dingus::CParticleCompositePhysics<TParticle>	TPPComposite;
	typedef dingus::CParticleAnimPhysics<TParticle>			TPPAnim;
	//typedef dingus::CParticleRepulsionPhysics<TParticle>	TPPRepulsion;

private:
	float	mPower;
	int		mOwner;
	bool	mShouldExplode;
	bool	mGrenade;
	int		mCounter;
	
	TParticleComp*		mParticles;
	TParticleRenderer*	mRenderer;
	TPPAnim*			mPPAnim;
	dingus::SMatrix4x4	mIdentity;
};


#endif
