#include "../stdafx.h"
#pragma hdrstop

#include "VehicleClass.h"

const std::string CVehicleClass::BODY_NAME = "body";
const std::string CVehicleClass::WHEEL_NAMES[MAX_WHEELS] = {
	"wheel_fr", "wheel_fl", "wheel_br", "wheel_bl"
};
const std::string CVehicleClass::TAG_NAMES[MAX_WHEELS] = {
	"tag_fr", "tag_fl", "tag_br", "tag_bl"
};

CVehicleClass::CVehicleClass( const std::string& name )
:	mName(name)
{
	mBodyClass = new CEntityClass("car_" + name + "/body");
	for( int i = 0; i < MAX_WHEELS; ++i ) {
		mWheelClass[i] = new CEntityClass( "car_" + name + '/' + WHEEL_NAMES[i] );
		mBodyWheelTags[i] = new CTag( TAG_NAMES[i] );
		mWheelTags[i] = new CTag( "wheel" );
	}
}

CVehicleClass::~CVehicleClass()
{
	delete mBodyClass;
	for( int i = 0; i < MAX_WHEELS; ++i ) {
		delete mWheelClass[i];
		delete mBodyWheelTags[i];
		delete mWheelTags[i];
	}
}

CEntityClass* CVehicleClass::getClassByName( const std::string& n )
{
	if( n == BODY_NAME )
		return mBodyClass;
	for( int i = 0; i < MAX_WHEELS; ++i ) {
		if( n == WHEEL_NAMES[i] )
			return mWheelClass[i];
	}
	return NULL;
}

CTag* CVehicleClass::getBodyWheelTagByName( const std::string& n )
{
	for( int i = 0; i < MAX_WHEELS; ++i ) {
		if( n == TAG_NAMES[i] )
			return mBodyWheelTags[i];
	}
	return NULL;
}

CTag* CVehicleClass::getWheelTagByName( const std::string& n )
{
	for( int i = 0; i < MAX_WHEELS; ++i ) {
		if( n == TAG_NAMES[i] )
			return mWheelTags[i];
	}
	return NULL;
}
