#include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <jam/entity/AmmoEntity.h>
#include <dingus/kernel/SystemClock.h>
#include <jam/entity/MissileEntity.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <dingus/resource/TextureBundle.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 20.0f );
	}
}
CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = "monster";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
		mView[i] = 0.0f;
		mGrenade[i] = false;
		mJustSwitched[i] = false;
		mLastMissile[i] = 0.0f;
	}

	SVector3 center = (level.getBounds().getAABB().getMin() + level.getBounds().getAABB().getMax()) * 0.5f;
	CLevel::TBaseEntityContainer::TEntityMap::iterator it, itEnd = level.getStaticEntities().getEntities().end();
	for( it = level.getStaticEntities().getEntities().begin(); it != itEnd; ++it ) {
		CBaseEntity& e = *it->second;
		if( e.getMatrix().getOrigin().y > center.y )
			e.setColor( 0x40807888 );
		else
			e.setColor( 0x40808878 );
	}
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/03.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		char buf[100];
		sprintf( buf, "score: %i", mScore[i] );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xC0FFFFFF
		);
		sprintf( buf, "ammo: %i", mVehicle[i]->getAmmo() );
		width = getTextRenderer().getWidth( buf, height );
		mAmmoText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height*2.2), height, 0xFFFFFFFF
		);
		std::string gun = mGrenade[i] ? "grenades" : "rockets";
		width = getTextRenderer().getWidth( gun, height );
		mGunText[i] = getTextRenderer().renderTextHeight( gun,
			SVector2(-width/2,i-height), height, 0xFFFFFFFF
		);
		mHelpText[i] = getTextRenderer().renderTextHeight(
			i ? "WSAD/R/F/Q/Space" : "Arrows/PgUp/PgDown/End/Ctrl",
			SVector2(-0.99f,i-height), height*0.6f, 0x80FFFFFF );
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
		delete mGunText[i];
		delete mAmmoText[i];
		delete mHelpText[i];
	}
}

void CMyGame::onUpdate()
{
	double t = CSystemClock::getInstance().getTime();

	const double AMMO_TIME = 2.2;
	if( t-mLastAmmo > AMMO_TIME ) {
		CLevel& level = CGameInfo::getInstance().getLevel();
		CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Barrel" );
		assert( clazz );
		const float THING_MASS = 20.0f;
		char buf[100];
		sprintf( buf, "m%i", mCounter++ );
		CAmmoEntity* e = new CAmmoEntity( buf, *clazz, (1<<COL_ENTITY_STATIC)|(1<<COL_ENTITY_CAR)|(1<<COL_ENTITY_MISSILE), level.getVisThing(), THING_MASS );
		//e->setColor( i ? 0xFFFF6020 : 0xFF60FF20 );
		e->getMatrix().identify();
		const SVector3& lmin = level.getBounds().getAABB().getMin();
		const SVector3& lmax = level.getBounds().getAABB().getMax();
		e->getMatrix().getOrigin().x = random( lmin.x, lmax.x );
		e->getMatrix().getOrigin().z = random( lmin.z, lmax.z );
		e->getMatrix().getOrigin().y = random( (lmin.y+lmax.y)/2, lmax.y );
		level.getThingEntities().addEntity( e );
		e->getPhysComp().setMatrixPORed( e->getMatrix() );
		e->attach();
		level.getBounds().addBoundable( e->getWorldMatrix(), e );
		mLastAmmo = t;
	}

	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyFire[VEHICLES] = { VK_CONTROL, ' ' };
	int keyViewUp[VEHICLES] = { VK_PRIOR, 'R' };
	int keyViewDown[VEHICLES] = { VK_NEXT, 'F' };
	int keyChange[VEHICLES] = { VK_END, 'Q' };

	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( 1/200.0f, SVector3(0,0,0), true );
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			std::string place = "start";
			place += '1'+rand()%4;
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue( place );
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;

		if( GetAsyncKeyState(keyChange[i]) ) {
			if( !mJustSwitched[i] ) {
				mGrenade[i] = !mGrenade[i];
			}
			mJustSwitched[i] = true;
		} else {
			mJustSwitched[i] = false;
		}

		if( GetAsyncKeyState(keyViewUp[i]) )
			mView[i] += 0.05f;
		if( GetAsyncKeyState(keyViewDown[i]) )
			mView[i] -= 0.05f;
		mView[i] *= 0.995f;
		if( mView[i] < -1.0f )
			mView[i] = -1.0f;
		if( mView[i] > 1.3f )
			mView[i] = 1.3f;

		mFollowCamera[i]->mHeight = 1.8f - mView[i];


		mVehicle[i]->control( accel, turn );

		const double INTERVAL = 0.5;
		if( GetAsyncKeyState(keyFire[i]) && t-mLastMissile[i]>INTERVAL && mVehicle[i]->getAmmo() > 0 ) {
			mLastMissile[i] = t;
			CLevel& level = CGameInfo::getInstance().getLevel();
			CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
			assert( clazz );
			const float THING_MASS = 100.0f;
			char buf[100];
			sprintf( buf, "m%i", mCounter++ );
			CMissileEntity* e = new CMissileEntity( buf, *clazz, (1<<COL_ENTITY_STATIC)|(1<<COL_ENTITY_CAR)|(1<<COL_ENTITY_MISSILE), level.getVisThing(), THING_MASS,
				7.0f, i, mGrenade[i] );
			e->setColor( i ? 0xFFFF6020 : 0xFF60FF20 );
			SMatrix4x4 camm = mVehicle[i]->getMatrix();
			camm.getOrigin() += camm.getAxisZ()*2.5f + camm.getAxisY()*0.5f;
			level.getThingEntities().addEntity( e );
			e->getPhysComp().setMatrixPORed( camm );
			e->attach();
			SVector3 f = camm.getAxisZ() * (mGrenade[i]?5.0e5f:1.0e6f) + camm.getAxisY() * 100000.0f;
			f.y += mView[i] * 200000.0f;
			e->getPhysComp().getPhysicsable().addForce( f );
			level.getBounds().addBoundable( e->getWorldMatrix(), e );
			mVehicle[i]->setAmmo( mVehicle[i]->getAmmo()-1 );
		}
	}

	CGameInfo::getInstance().getLevel().update();
}
