function makePart( tex, mode )
	local fxs = { 'textured.fx', 'texturedAlpha.fx', 'texturedEnv.fx' }
	local layers = { 0, 1, 0 }
	return { texture=tex, fx=fxs[mode], layer=layers[mode] }
end
modeSimple = 1
modeAlpha = 2
modeEnv = 3

wheel = { makePart( 'cars/goomWheel.png', modeSimple ) }

body = {
	makePart( 'cars/monsterBody.png', modeEnv ), -- body
	makePart( 'roadSide01.png', modeAlpha ) -- glass
}
wheel_fr = wheel
wheel_fl = wheel
wheel_br = wheel
wheel_bl = wheel
