#include "stdafx.h"
#pragma hdrstop

#include "GameSystem.h"
#include <unco/kernel/EngineApplication.h>
#include <unco/kernel/Contexts.h>
#include <unco/kernel/AppContext.h>

#include <dingus/dxutils/D3DFont.h>

#include <dingus/kernel/SystemClock.h>
#include <dingus/kernel/D3DDevice.h>

#include <dingus/resource/SharedTextureBundle.h>
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/resource/EffectBundle.h>
#include <dingus/resource/VertexDeclBundle.h>
#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/CollisionMeshBundle.h>
#include <dingus/resource/LuaWrapperBundle.h>
#include <dingus/resource/DeviceResource.h>
#include <dingus/resource/ReloadableBundle.h>

#include <dingus/renderer/RenderContext.h>
#include <dingus/renderer/RenderStage.h>
#include <dingus/portal/PortalContext.h>
#include <dingus/portal/PortalStage.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <dingus/collider-ode/CollisionStage.h>
#include <dingus/physics-ode/PhysicsContext.h>
#include <dingus/physics-ode/PhysicsStage.h>
#include <dingus/visibility/VisibilityContext.h>
#include <dingus/visibility/VisibilityStage.h>
//#include <dingus/input/InputContext.h>
//#include <dingus/input/InputStage.h>
//#include <dingus/input/DIKeyboard.h>
//#include <dingus/input/DIMouse.h>

#include <dingus/pipeline/Pipeline.h>
#include <dingus/pipeline/FixedRatePipeline.h>

#include <dingus/gfx/geometry/DynamicVBManager.h>

#include <dingus/console/FileConsoleRenderingContext.h>
#include <dingus/console/D3DConsoleRenderingContext.h>


CGameSystem::CGameSystem( unco::IEngineApplication& application )
:	mApplication( &application ),
	mAppInited( false )
{
	unco::SStartupParams params = mApplication->getStartupParams();
	mCreationWidth		= params.windowWidth;
	mCreationHeight 	= params.windowHeight;
	mWindowTitle		= params.windowTitle;
	mStartFullscreen	= params.startFullscreen;
	mShowCursorWhenFullscreen			= params.showCursorFullscreen;
	mEnumeration.mUsesDepthBuffer		= params.usesZBuffer;
	mEnumeration.mMinColorChannelBits	= params.minColorBits;
	mEnumeration.mMinAlphaChannelBits	= params.minAlphaBits;
	mEnumeration.mMinDepthBits			= params.minZBits;
	mEnumeration.mMinStencilBits		= params.minStencilBits;
	mDataPath = params.dataPath;

	mFont = new dingus::CD3DFont( "Arial", 10, dingus::CD3DFont::BOLD );
};


CGameSystem::~CGameSystem()
{
	delete mFont;
}


HRESULT CGameSystem::initialize()
{
	//
	// init console

	mStdConsoleCtx = new dingus::CFileConsoleRenderingContext( "log.txt" );
	dingus::CConsole::getInstance().setDefaultRenderingContext( *mStdConsoleCtx );

	/**/
	dingus::CD3DTextBoxConsoleRenderingContext* ctxSystem = 
		new dingus::CD3DTextBoxConsoleRenderingContext( *mFont, 2, 2, 0x60FFFF80 );
	
	mD3DConsoleCtxs.push_back( ctxSystem );

	dingus::CConsole::getChannel( "system" ).setRenderingContext( *ctxSystem );
	/**/
	
	//
	// resources

	const std::string basePath = mDataPath;
	dingus::CTextureBundle::init( basePath + "tex/" );
	dingus::CMeshBundle::init( basePath + "mesh/" );
	dingus::CEffectBundle::init( basePath + "fx/" );
	dingus::CCollisionMeshBundle::init( basePath + "mesh/" );
	dingus::CLuaWrapperBundle::init( basePath + "script/" );
	dingus::CSharedTextureBundle::init();
	dingus::CVertexDeclBundle::init();
	dingus::CIndexBufferBundle::init();

	dingus::CDynamicVBManager *vbManager = new dingus::CDynamicVBManager( 2 * 1024 * 1024 ); // 2 megabytes

	//
	// device dependant resources

	mDeviceManager = new dingus::CDeviceResourceManager();
	mDeviceManager->add( dingus::CSharedTextureBundle::getInstance() );
	mDeviceManager->add( *vbManager );
	mDeviceManager->add( dingus::CTextureBundle::getInstance() );
	mDeviceManager->add( dingus::CMeshBundle::getInstance() );
	mDeviceManager->add( dingus::CEffectBundle::getInstance() );
	mDeviceManager->add( dingus::CVertexDeclBundle::getInstance() );
	mDeviceManager->add( dingus::CIndexBufferBundle::getInstance() );

	//
	// reloadable resources

	mReloadableManager = new dingus::CReloadableBundleManager();
	mReloadableManager->add( dingus::CTextureBundle::getInstance() );
	mReloadableManager->add( dingus::CMeshBundle::getInstance() );
	mReloadableManager->add( dingus::CEffectBundle::getInstance() );
	//mReloadableManager->add( dingus::CCollisionMeshBundle::getInstance() ); // TBD

	//
	// contexts

	mPipeline = new dingus::CPipeline();
	mPortalPipeline = new dingus::CPipeline();

	unco::CContextRegistry& ctxs = unco::CContextRegistry::getInstance();
	ctxs.setContext( unco::CTX_RENDER, new dingus::CRenderContext() );
	ctxs.setContext( unco::CTX_VIS, new dingus::CVisibilityContext() );
	//ctxs.setContext( CTX_INPUT, new dingus::CInputContext() );
	ctxs.setContext( unco::CTX_PORTAL, new dingus::CPortalContext( *mPortalPipeline ) );
	ctxs.setContext( unco::CTX_COLLISION, new dingus::CCollisionContext() );
	ctxs.setContext( unco::CTX_PHYSICS, new dingus::CPhysicsContext() );
	ctxs.setContext( unco::CTX_DYNAVB, vbManager );

	//
	// input devices

	/*
	HRESULT hr;

	IDirectInput8* directInput8 = NULL;
	hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&directInput8, NULL );
	assert( SUCCEEDED( hr ) );
	assert( directInput8 );
	CContexts::getInputCtx().addDevice( *(new dingus::CDIKeyboard(mHWnd,*directInput8)) );
	CContexts::getInputCtx().addDevice( *(new dingus::CDIMouse(mHWnd,*directInput8)) );
	*/

	//
	// pipeline


	dingus::IPipelineStage* stage;

	// input stage
	//stage = new dingus::CInputStage( CContexts::getInputCtx() );
	//mCreatedPipelineStages.push_back( stage );
	//mPipeline->addStage( *stage );

	// fixed rate subpipe for collision and physics stages
	dingus::CFixedRatePipeline* fixedPipe = new dingus::CFixedRatePipeline();
	mCreatedPipelineStages.push_back( fixedPipe );
	fixedPipe->setPerformFreq( 200.0 );
	mPipeline->addStage( *fixedPipe );

	// application - to fixed pipe
	fixedPipe->addStage( *mApplication );

	// collision stage - to fixed pipe
	stage = new dingus::CCollisionStage( unco::CContexts::getCollisionCtx() );
	mCreatedPipelineStages.push_back( stage );
	fixedPipe->addStage( *stage );

	// physics stage - to fixed pipe
	stage = new dingus::CPhysicsStage( unco::CContexts::getPhysicsCtx(), fixedPipe->getPerformDT(), 5 );
	mCreatedPipelineStages.push_back( stage );
	fixedPipe->addStage( *stage );

	// visibility stage - to portal subpipe
	stage = new dingus::CVisibilityStage( unco::CContexts::getVisCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPortalPipeline->addStage( *stage );


	// render stage - to portal subpipe
	stage = new dingus::CRenderStage( unco::CContexts::getRenderCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPortalPipeline->addStage( *stage );

	// portal stage
	stage = new dingus::CPortalStage( unco::CContexts::getPortalCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPipeline->addStage( *stage );


	return S_OK;
}


HRESULT CGameSystem::checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format )
{
	return mApplication->checkDevice( caps, behavior, format ) ? S_OK : E_FAIL;
}



HRESULT CGameSystem::createDeviceObjects()
{
	dingus::gD3DDevice = mD3DDevice;

	mFont->createDeviceObjects( *mD3DDevice );
	
	unco::CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );

	mDeviceManager->createResource();

	if( !mAppInited ) {
		mApplication->initialize();
		mAppInited = true;
	}

	unco::CContexts::getRenderCtx().notifyChanged();

	return S_OK;
}


HRESULT CGameSystem::activateDeviceObjects()
{
	mFont->activateDeviceObjects();
	unco::CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );
	mDeviceManager->activateResource();
	return S_OK;
}


HRESULT CGameSystem::performOneTime()
{
	dingus::CSystemClock& c = dingus::CSystemClock::getInstance();
	c.setTimes( mTime, mElapsedTime, c.getPerformCount()+1 );
	unco::CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );

	//
	// discard dynamic VBs

	unco::CContexts::getDynamicVBManager().discard();

	//
	// pipeline

	unco::CContexts::getRenderCtx().getStats().reset();
	mApplication->onBeginPerform();
	mPipeline->perform();
	mApplication->onEndPerform();

	//
	// stats

	dingus::CConsoleChannel& cc = dingus::CConsole::getChannel( "system" );
	cc.write( mFrameStats );
	cc.write( mDeviceStats );
	dingus::CRenderStats const& stats = unco::CContexts::getRenderCtx().getStats();
	char buf[200];
	sprintf( buf, "Draw calls: %i  Vertices: %i  Prims: %i", stats.getDrawCalls(), stats.getVerticesRendered(), stats.getPrimsRendered() );
	cc.write( buf );
	
	dingus::gD3DDevice->BeginScene();
	TD3DConsoleCtxVector::iterator it, itEnd = mD3DConsoleCtxs.end();
	for( it = mD3DConsoleCtxs.begin(); it != itEnd; ++it ) {
		(*it)->flush();
	}
	dingus::gD3DDevice->EndScene();
	
	return S_OK;
}


LRESULT CGameSystem::msgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	/*
	static bool reloadKeyPressed = false;
	switch( msg ) {
	case WM_KEYDOWN:
		if( wParam == VK_F5 )
			reloadKeyPressed = true;
		break;
	case WM_KEYUP:
		if( wParam == VK_F5 ) {
			if( reloadKeyPressed ) {
				mReloadableManager->reload();
				CContexts::getRenderCtx().notifyChanged();
			}
			reloadKeyPressed = false;
		}
	}
	*/
	return CD3DApplication::msgProc( hWnd, msg, wParam, lParam );
}


HRESULT CGameSystem::passivateDeviceObjects()
{
	mFont->passivateDeviceObjects();
	mDeviceManager->passivateResource();
	return S_OK;
}

HRESULT CGameSystem::deleteDeviceObjects()
{
	mFont->deleteDeviceObjects();
	mDeviceManager->deleteResource();
	dingus::gD3DDevice = NULL;
	return S_OK;
}


HRESULT CGameSystem::shutdown()
{
	mApplication->shutdown();

	mDeviceManager->clear();
	delete mDeviceManager;

	mReloadableManager->clear();
	delete mReloadableManager;

	delete &unco::CContexts::getRenderCtx();
	delete &unco::CContexts::getVisCtx();
	delete &unco::CContexts::getDynamicVBManager();
	//dingus::stl_utils::wipe( CContexts::getInputCtx().getDevices() );
	//delete &unco::CContexts::getInputCtx();
	delete &unco::CContexts::getCollisionCtx();
	delete &unco::CContexts::getPhysicsCtx();
	delete &unco::CContexts::getPortalCtx();
	unco::CContextRegistry::finalize();
	unco::CAppContext::finalize();
	

	dingus::CTextureBundle::finalize();
	dingus::CMeshBundle::finalize();
	dingus::CEffectBundle::finalize();
	dingus::CVertexDeclBundle::finalize();
	dingus::CSharedTextureBundle::finalize();
	dingus::CIndexBufferBundle::finalize();
	dingus::CCollisionMeshBundle::finalize();
	dingus::CLuaWrapperBundle::finalize();

	dingus::stl_utils::wipe( mCreatedPipelineStages );
	delete mPipeline;

	dingus::CSystemClock::finalize();
	dingus::stl_utils::wipe( mD3DConsoleCtxs );
	dingus::CConsole::finalize();

	return S_OK;
}
