  #include "../stdafx.h"
#pragma hdrstop

#include "BasePhysicsEntity.h"


CBasePhysicsEntity::CBasePhysicsEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp, float mass )
:	CBaseEntity( name, clazz, catBits, colBits, flipCull, visComp ),
	mMass(mass)
{
	mPhysComp = new unco::CPhysicsComponent( getMatrix() );
	addComponent( *mPhysComp );
	const dMass& m = getClass().getMass();
	getPhysComp().getPOROffset().set( m.c[0], m.c[1], m.c[2] );
}

CBasePhysicsEntity::CBasePhysicsEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp, float mass,
		dingus::CCollidableContainer& colContainer )
:	CBaseEntity( name, clazz, catBits, colBits, flipCull, visComp, colContainer ),
	mMass(mass)
{
	mPhysComp = new unco::CPhysicsComponent( getMatrix() );
	addComponent( *mPhysComp );
	const dMass& m = getClass().getMass();
	getPhysComp().getPOROffset().set( m.c[0], m.c[1], m.c[2] );
}

void CBasePhysicsEntity::internalAttach()
{
	dMass m = getClass().getMass();
	dMassAdjust( &m, mMass );
	m.c[0] = m.c[1] = m.c[2] = m.c[3] = 0.0;
	dBodySetMass( getPhysComp().getPhysicsable(), &m);
}
