#ifndef __THING_ENTITY_H
#define __THING_ENTITY_H

#include "BasePhysicsEntity.h"
#include "CollideClasses.h"


class CThingEntity : public CBasePhysicsEntity {
public:
	CThingEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp, float mass )
		: CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_THING, colBits, false, visComp, mass ) { }
};

class CBulletEntity : public CThingEntity {
public:
	CBulletEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp, float mass )
		: CThingEntity( name, clazz, colBits, visComp, mass ) { }
	virtual bool onLevelBound() {
		return false;
	}
};


#endif
