#ifndef __LEVEL_BOUNDS_H
#define __LEVEL_BOUNDS_H

#include <dingus/math/AABox.h>


class ILevelBoundListener {
public:
	virtual ~ILevelBoundListener() =0 { }

	/** @return true if should remove this listener from listener list. */
	virtual bool onLevelBound() = 0;
};


class CLevelBounds {
public:
	static const float BOUND_DIST;
public:
	const dingus::CAABox& getAABB() const { return mAABB; }

	void extend( const SVector3& p ) { mAABB.extend( p, BOUND_DIST ); }

	void addBoundable( const dingus::SMatrix4x4& worldMatrix, ILevelBoundListener* listener ) {
		mBoundables.insert( std::make_pair(&worldMatrix,listener) );
	}
	void removeBoundable( const dingus::SMatrix4x4& worldMatrix ) {
		mBoundables.erase( &worldMatrix );
	}

	void update();

private:
	typedef std::map<const dingus::SMatrix4x4*,ILevelBoundListener*> TBoundableMap;

private:
	dingus::CAABox	mAABB;
	TBoundableMap	mBoundables;
};


#endif
