 #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>
#include <dingus/utils/Random.h>
#include <dingus/resource/TextureBundle.h>

//DWORD colors[2] = { 0xffff0000, 0xff00ff00 };
DWORD colors[2] = { 0x40ff5555, 0x4055ff55 };

CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 20.0f );
	}
}

CMyGame::~CMyGame()
{
}

#define XLENGTH 10  
#define ZLENGTH 20

#define XMID XLENGTH / 2
#define ZDELTA 3

#define FLAG_PLACE 100

int lev[XLENGTH][ZLENGTH];

void CMyGame::createLevel()
{
	char buff[200];
	SMatrix4x4 m;

	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	//CLevelFileReader::read( name.c_str(), creator );

	for( int i = 0; i < XLENGTH; i++ )
		for( int j = 0; j < ZLENGTH; j++ ) lev[i][j] = 0;
	
	srand( time( NULL ) );
	


	lev[XMID	][ZDELTA	] = FLAG_PLACE;
	lev[XMID + 1][ZDELTA	] = FLAG_PLACE;
	lev[XMID	][ZDELTA + 1] = FLAG_PLACE;
	lev[XMID + 1][ZDELTA + 1] = FLAG_PLACE;

	lev[XMID	][ZLENGTH - ZDELTA - 1] = FLAG_PLACE;
	lev[XMID + 1][ZLENGTH - ZDELTA - 1] = FLAG_PLACE;
	lev[XMID	][ZLENGTH - ZDELTA	  ] = FLAG_PLACE;
	lev[XMID + 1][ZLENGTH - ZDELTA    ] = FLAG_PLACE;

	for( int k = 0; k < 25; k++ ) {
		int i = ( rand() % ( XLENGTH - 2 ) ) + 1;
		int j = ( rand() % ( ZLENGTH - 2 ) ) + 1;

		int val = lev[i][j];

		if( ( rand() % 2 ) == 1 ) lev[i][j]++;
		else lev[i][j]--;
		
		bool b = true;

		std::string name;

		int dx = -1, dz = -1;
		getElement( name, m, lev[i + dx][j + dz], lev[i + dx][j + 1 + dz], lev[i + 1 + dx][j + 1 + dz], lev[i + 1 + dx][j + dz] );
		b = b && ( name.size() > 0 );
		dx = 0, dz = -1;
		getElement( name, m, lev[i + dx][j + dz], lev[i + dx][j + 1 + dz], lev[i + 1 + dx][j + 1 + dz], lev[i + 1 + dx][j + dz] );
		b = b && ( name.size() > 0 );
		dx = 0, dz = 0;
		getElement( name, m, lev[i + dx][j + dz], lev[i + dx][j + 1 + dz], lev[i + 1 + dx][j + 1 + dz], lev[i + 1 + dx][j + dz] );
		b = b && ( name.size() > 0 );
		dx = -1, dz = 0;
		getElement( name, m, lev[i + dx][j + dz], lev[i + dx][j + 1 + dz], lev[i + 1 + dx][j + 1 + dz], lev[i + 1 + dx][j + dz] );
		b = b && ( name.size() > 0 );

		if( !b )  lev[i][j] = val;
	}

	for( i = 0; i < XLENGTH; i++ )
		for( int j = 0; j < ZLENGTH; j++ ) 
			if( lev[i][j] == FLAG_PLACE ) lev[i][j] = 1;

	for( i = 0; i < XLENGTH - 1; i++ )
		for( int j = 0; j < ZLENGTH - 1; j++ ) {
			sprintf( buff, "t%i%i", i, j );

			std::string name;

			getElement( name, m, lev[i][j], lev[i][j + 1], lev[i + 1][j + 1], lev[i + 1][j] );

			m.getOrigin().x = getHeight( i, j ).x;
			m.getOrigin().z = getHeight( i, j ).z;
			
			if( name.size() > 0 ) {
				creator.createStaticEntity( buff, name, m, false );
								
				int colNum = -1;
								
				if( i == XMID - 1 || i == XMID || i == XMID + 1 ) {
					if( j == ZDELTA - 1 || j == ZDELTA || j == ZDELTA + 1 || j == ZLENGTH - ZDELTA - 1 || j == ZLENGTH - ZDELTA || j == ZLENGTH - ZDELTA - 2 ) 
						colNum = 0;
				}

				if( colNum == 0 ) {
					if( j > ZLENGTH / 2 ) colNum = 1;

					TEntityPtr entityptr = level.getStaticEntities().findEntity( buff );
					CEntity& entity = *entityptr;
					((CBaseEntity&)entity).setColor( colors[colNum] );
				}
			}
		}

	SVector3 delta( 0, -0.5, 0 );
	for( i = 0; i < XLENGTH; i++ ) {
		for( int j = 0; j < 4; j++ ) {
			D3DXMatrixRotationX( &m, D3DX_PI / 2 );
			bool t = false;
			switch( j ) {
				case 0:	m.getOrigin() = getHeight( i, 0 ) + SVector3( -1, 3, -3 ); t = true; break;
				//case 1: m.getOrigin() = getHeight( i, 0 ) + SVector3( 0, 9, 1 ); t = true; break;
				case 2: m.getOrigin() = getHeight( i, ZLENGTH - 1 ) + SVector3( 0, 3, -3 ); t = true; break;
				//case 3: m.getOrigin() = getHeight( i, ZLENGTH - 1 ) + SVector3( 0, 9, -3 ); t = true; break;
			}

			m.getOrigin() += delta;
			sprintf( buff, "tx%i%i", j, i );
			if( t ) creator.createStaticEntity( buff, "Square", m, false );
		}
	}

	for( i = 0; i < ZLENGTH; i++ ) {
		for( int j = 0; j < 4; j++ ) {
			D3DXMatrixRotationZ( &m, D3DX_PI / 2 );
			bool t = false; 
			switch( j ) {
				case 0:	m.getOrigin() = getHeight( 0, i ) + SVector3( -4, 3, 0 ); t = true; break;
				//case 1: m.getOrigin() = getHeight( 0, i ) + SVector3( 1, 9, 0 ); t = true; break;
				case 2: m.getOrigin() = getHeight( XLENGTH - 1, i ) + SVector3( -3, 3, 0 ); t = true; break;
				//case 3: m.getOrigin() = getHeight( XLENGTH - 1, i ) + SVector3( -3, 9, 0 ); t = true; break;
			}

			m.getOrigin() += delta;
			sprintf( buff, "tz%i%i", j, i );
			if( t ) creator.createStaticEntity( buff, "Square", m, false );
		}
	}

	m.identify();
	m.getOrigin() = getHeight( XMID, ZDELTA ) + SVector3( 0, 4, 0 );
	mFlags[0] = creator.createBulletEntity( "flag1", "Sphere", m );
	mFlags[0]->setColor( colors[0] );

	m.identify();
	m.getOrigin() = getHeight( XMID, ZLENGTH - ZDELTA - 1 ) + SVector3( 0, 4, 0 );
	mFlags[1] = creator.createBulletEntity( "flag2", "Sphere", m );
	mFlags[1]->setColor( colors[1] );

	
	
	//int i;
	for( i = 0; i < VEHICLES; ++i ) {
		//const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");

		mCurrentBullet[i] = 0;
		mLastBulletDelta[i] = 1000;
		mFlagStates[i] = RETURNED;

		mLastStatus[i] = 0;
		mStatus[i] = "";

		for( int j = 0; j < BULLETS; j++ ) {
			m.identify();
			m.getOrigin().y = 4;
			sprintf( buff, "bl%i%i", i, j );
			mBullets[i][j] = creator.createBulletEntity( buff, "Cube", m );
			mBullets[i][j]->setColor( colors[i] );

		}

		SMatrix4x4 markM;
		markM.identify();

		if( i == 0 ) {
			markM.getOrigin() = getHeight( XMID, ZDELTA ) + SVector3( 0, 0, 6 );			
		} else {
			D3DXMatrixRotationY( &markM, D3DX_PI );
			markM.getOrigin() = getHeight( XMID, ZLENGTH - ZDELTA - 1 ) - SVector3( 0, 0, 6 );
		}


		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 2.0f;
		//const char* name = i ? "monster" : "goom";
		const char* name = "monster";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		mVehicle[i]->getBody().setColor( colors[i] );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		for( j = 0; j < 4; j++ )
			mVehicle[i]->getWheel( j ).setColor( colors[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}

	tx = dingus::CTextureBundle::getInstance().getResourceById( "CTB.png" );
	b = &getBillboards().addBill( *tx );

	b->tu1 = 0;
	b->tu2 = 1;
	b->tv1 = 0;
	b->tv2 = 1;

	b->x1 = -1;
	b->x2 = 1;
	b->y1 = -0.8f;
	b->y2 = 0.8f;


	//b->texture = texture;
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel();
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		char buf[100];
		sprintf( buf, "Captured balls: %i", mScore[i] );
		float height = 0.12f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, colors[i]
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
	}
}

#define PHYSICS_OFF_MODE true

void CMyGame::onUpdate()
{
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyFire[VEHICLES] = { VK_NUMPAD0, VK_CONTROL };

	for( int i = 0; i < VEHICLES; ++i ) {
		SMatrix4x4 markM;
		markM.identify();
		if( i == 0 ) {
			markM.getOrigin() = getHeight( XMID, ZDELTA );			
		} else {
			D3DXMatrixRotationY( &markM, D3DX_PI );
			markM.getOrigin() = getHeight( XMID, ZLENGTH - ZDELTA - 1 );
		}

		

		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = markM;
			mVehicle[i]->getMatrix().getOrigin().y += 5.0f;
			mVehicle[i]->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}

		if( PHYSICS_OFF_MODE ) {
			/*//SVector3 pos = mVehicle[i]->getMatrix().getOrigin();
			SVector3 pos = mVehicle[i]->getBody().getPhysComp().getPhysicsable().getPosition();
			getHeight( pos.x, pos.z, pos );
			//pos.y += 2;
			mVehicle[i]->getBody().getPhysComp().getPhysicsable().setPosition( pos );

			//mVehicle[i]->detach();
			mVehicle[i]->getMatrix().getOrigin() = pos;
			//mVehicle[i]->getMatrix().getOrigin() = pos + SVector3( 0, 2, 0 );
			//mVehicle[i]->attach();*/
		}

		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			if(accel>0) accel -= 10;
            else accel -= 1;
		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;
		if( GetAsyncKeyState(VK_ESCAPE) )
			exit(0);

		if( ( accel != 0 || turn != 0 ) && b ) {
			b->discard();
			b = NULL;
		}


		int my = i;
		int notmy = 1 - i;

		SMatrix4x4& mv = mVehicle[i]->getMatrix();
		SMatrix4x4& mnf = mFlags[notmy]->getMatrix();
		SMatrix4x4& mmf = mFlags[my]->getMatrix();

		
		


		if( GetAsyncKeyState(keyFire[i]) && mLastBulletDelta[i] > 0.5f ) {
			CBasePhysicsEntity* e = mBullets[i][mCurrentBullet[i]];
			e->getPhysComp().getPhysicsable().setPosition( mv.getOrigin() + mv.getAxisZ() * 2.5f + mv.getAxisY() * 1 );
			float ang = 0.8f;
			e->getPhysComp().getPhysicsable().setLinearVel( ( mv.getAxisZ() * ang + mv.getAxisY() * ( 1 - ang ) ) * 30 );			

			mLastBulletDelta[i] = 0;
			mCurrentBullet[i]++;
			if( mCurrentBullet[i] == BULLETS ) mCurrentBullet[i] = 0;
		}
		mLastBulletDelta[i] += 0.005f;

		

		mVehicle[i]->control( accel, turn );

		SVector3 flagStart[2];
		flagStart[ i == 0 ? my : notmy ] = getHeight( XMID, ZDELTA );
		flagStart[ i == 0 ? notmy : my ] = getHeight( XMID, ZLENGTH - ZDELTA - 1 );

		if( mFlags[my]->getMatrix().getOrigin().y < -10 )
			mFlagStates[my] = RETURNED;

		if( mFlagStates[notmy] == RETURNED || mFlagStates[notmy] == FREE ) {
			if( mFlagStates[notmy] == RETURNED )
				mFlags[notmy]->getPhysComp().getPhysicsable().setPosition( flagStart[notmy] + SVector3( 0, 2, 0 ) );

			if( D3DXVec3Length( &( mv.getOrigin() - mnf.getOrigin() ) ) < 3 )
				mFlagStates[notmy] = TAKE;
		} else if( mFlagStates[notmy] == TAKE ) {
			mFlags[notmy]->getPhysComp().getPhysicsable().setPosition( mv.getOrigin() + mv.getAxisY() * 2 );

			for( int j = 0; j < BULLETS; j++ )
				if( D3DXVec3Length( &( mBullets[notmy][j]->getMatrix().getOrigin() - mnf.getOrigin() ) ) < 2 ) {
					mFlagStates[notmy] = LOST;
					//mFlags[notmy]->getPhysComp().getPhysicsable().setLinearVel( SVector3( 0, 0, 0 ) );
					float f = 1;
					mFlags[notmy]->getPhysComp().getPhysicsable().setLinearVel( SVector3( dingus::random( -f, f ), dingus::random( -f, f ), dingus::random( -f, f ) ) );
				}

			if( mFlagStates[my] == RETURNED &&
				D3DXVec3Length( &( mv.getOrigin() - flagStart[my] ) ) < 3 ) 
			{			
				mScore[i]++;
				mFlagStates[notmy] = RETURNED;
				mFlags[notmy]->getPhysComp().getPhysicsable().setPosition( flagStart[notmy] + SVector3( 0, 2, 0 ) );
			}
		} else if( mFlagStates[notmy] == LOST ) {
			if( D3DXVec3Length( &( mv.getOrigin() - mnf.getOrigin() ) ) > 3.5 )
				mFlagStates[notmy] = FREE;
		} 
		
		if( mFlagStates[my] == LOST || mFlagStates[my] == FREE )
			if( D3DXVec3Length( &( mv.getOrigin() - mmf.getOrigin() ) ) < 3 ) {
				mFlagStates[my] = RETURNED;
				mFlags[my]->getPhysComp().getPhysicsable().setPosition( flagStart[my] + SVector3( 0, 2, 0 ) );
			}
	}

	CGameInfo::getInstance().getLevel().update();
}

void CMyGame::getElement( std::string& name, SMatrix4x4& m, int h1, int h2, int h3, int h4 )
{
	m.identify();

	int min = h1;
	if( h2 < min ) min = h2;
	if( h3 < min ) min = h3;
	if( h4 < min ) min = h4;

	h1 -= min;
	h2 -= min;
	h3 -= min;
	h4 -= min;

	float rot = 0;

	name = "";

	if( h1 == 0 && h2 == 0 && h3 == 0 && h4 == 0 ) {
		name = "Square";
		rot = 0;
	} else if( h1 == 1 && h2 == 0 && h3 == 0 && h4 == 0 ) {
		name = "SquareCorner2";
		rot = D3DX_PI * 2 * 3 / 4;
	} else if( h1 == 0 && h2 == 1 && h3 == 0 && h4 == 0 ) {
		name = "SquareCorner2";
		rot = 0;
	} else if( h1 == 0 && h2 == 0 && h3 == 1 && h4 == 0 ) {
		name = "SquareCorner2";
		rot = D3DX_PI * 2 / 4;
	} else if( h1 == 0 && h2 == 0 && h3 == 0 && h4 == 1 ) {
		name = "SquareCorner2";
		rot = D3DX_PI;
	} else if( h1 == 1 && h2 == 1 && h3 == 0 && h4 == 0 ) {
		name = "SquareUp";
		rot = D3DX_PI * 2 * 3 / 4;
	} else if( h1 == 0 && h2 == 1 && h3 == 1 && h4 == 0 ) {
		name = "SquareUp";
		rot = 0;
	} else if( h1 == 0 && h2 == 0 && h3 == 1 && h4 == 1 ) {
		name = "SquareUp";
		rot = D3DX_PI * 2 / 4;
	} else if( h1 == 1 && h2 == 0 && h3 == 0 && h4 == 1 ) {
		name = "SquareUp";
		rot = D3DX_PI;
	} else if( h1 == 0 && h2 == 1 && h3 == 1 && h4 == 1 ) {
		name = "SquareCorner1";
		rot = D3DX_PI * 2 /4;
	} else if( h1 == 1 && h2 == 0 && h3 == 1 && h4 == 1 ) {
		name = "SquareCorner1";
		rot = D3DX_PI;
	} else if( h1 == 1 && h2 == 1 && h3 == 0 && h4 == 1 ) {
		name = "SquareCorner1";
		rot = D3DX_PI * 2 * 3 / 4;
	} else if( h1 == 1 && h2 == 1 && h3 == 1 && h4 == 0 ) {
		name = "SquareCorner1";
		rot = 0;
	}

	D3DXMatrixRotationY( &m, rot );
	m.getOrigin().y = min * 2;

}

SVector3 CMyGame::getHeight( int i, int j )
{
	return SVector3( i * 6 - XLENGTH / 2 * 6, lev[i][j] * 2, j * 6 - ZLENGTH / 2 * 6 );
	//return SVector3( i * 6, lev[i][j] * 2, j * 6 );
}

void CMyGame::getHeight( float fi, float fj, SVector3& pos )
{
	fi = fi / 6 + XLENGTH / 2;
	fj = fj / 6 + ZLENGTH / 2;

	assert( fi >= 0 && fi < XLENGTH );
	assert( fj >= 0 && fj < ZLENGTH );

	int i = int( fi );
	int j = int( fj );

	float ai = fi - i;
	float aj = fj - j;

	SVector3 v00 = getHeight( i, j );
	SVector3 v01 = getHeight( i, j + 1 );
	SVector3 v11 = getHeight( i + 1, j + 1 );
	SVector3 v10 = getHeight( i + 1, j );

	SVector3 v0;
	SVector3 v1;
	SVector3 v;

	D3DXVec3Lerp( &v0, &v00, &v01, aj );
	D3DXVec3Lerp( &v1, &v10, &v11, aj );

	D3DXVec3Lerp( &v, &v0, &v1, ai );

	pos.y = v.y;
}