#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
#include <jam/BaseGame.h>
#include <jam/utils/FollowCameraController.h>
#include <jam/entity/Vehicle.h>


class CBulletEntity;

class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame> {
public:
	enum { VEHICLES = 2, BULLETS = 10 };
public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

private:
	void	createLevel();

	void getElement( std::string& name, SMatrix4x4& m, int h1, int h2, int h3, int h4 );

	SVector3 getHeight( int i, int j );
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;

	enum eFlagState{ RETURNED, TAKE, LOST, FREE };

	void getHeight( float fi, float fj, SVector3& pos );
private:
	CFollowCameraController*	mFollowCamera[VEHICLES];
	CVehicle*					mVehicle[VEHICLES];
	int							mScore[VEHICLES];
	CTextRenderer::CRenderedText*	mScoreText[VEHICLES];

	CBulletEntity* mFlags[2];
	eFlagState mFlagStates[2];

	CBulletEntity* mBullets[2][BULLETS];
	int mCurrentBullet[2];

	float mLastBulletDelta[2];

	std::string mStatus[2];
	float mLastStatus[2];

	CD3DTexture *tx;
	SBillboard* b;
	SBillboard* b1;
};


#endif
