#ifndef __GAME_SYSTEM_H
#define __GAME_SYSTEM_H

#include <dingus/dxutils/D3DApplication.h>

namespace dingus {
	class CDeviceResourceManager;
	class CReloadableBundleManager;
	class CPipeline;
	class CD3DFont;
	class IConsoleRenderingContext;
	class CD3DTextBoxConsoleRenderingContext;
	class IPipelineStage;
};


namespace unco {
class IEngineApplication;
};


class CGameSystem : public dingus::CD3DApplication {
public:
	CGameSystem( unco::IEngineApplication& application );
	virtual ~CGameSystem();

	LRESULT msgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

protected:
	virtual HRESULT initialize();
	virtual HRESULT createDeviceObjects();
	virtual HRESULT activateDeviceObjects();
	virtual HRESULT passivateDeviceObjects();
	virtual HRESULT deleteDeviceObjects();
	virtual HRESULT performOneTime();
	virtual HRESULT shutdown();
	virtual HRESULT checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT bbFormat );

private:
	typedef std::vector<dingus::CD3DTextBoxConsoleRenderingContext*>	TD3DConsoleCtxVector;
	typedef std::vector<dingus::IPipelineStage*>	TPipelineStageVector;

private:
	unco::IEngineApplication*			mApplication;
	const char*							mDataPath;
	dingus::CDeviceResourceManager*		mDeviceManager;
	dingus::CReloadableBundleManager*	mReloadableManager;
	dingus::CPipeline*					mPipeline;
	dingus::CPipeline*					mPortalPipeline;
	dingus::CD3DFont*					mFont;
	dingus::IConsoleRenderingContext*	mStdConsoleCtx;
	TD3DConsoleCtxVector				mD3DConsoleCtxs;
	TPipelineStageVector				mCreatedPipelineStages;
	
	bool								mAppInited;
};


#endif
