#ifndef _BALL_H_
#define _BALL_H_

#include "ThingEntity.h"

class CBall : public CThingEntity
{
	bool m_bOutOfBounds;
	bool m_bBlue;
	
public:

	CBall( bool bBlue, const std::string& name, const CEntityClass& clazz, 
		  int colBits, unco::CVisibilityComponent& visComp, float mass) :
			CThingEntity( name, clazz, colBits,visComp, mass ), m_bBlue( bBlue )
	{m_bOutOfBounds = false;}

	virtual bool onLevelBound();


	inline void SetOutOfBounds(bool bVal) {m_bOutOfBounds = bVal;}
	inline bool IsOutOfBounds() const {return m_bOutOfBounds;}

	bool IsBlue() const { return m_bBlue; };
};

#endif