#ifndef __BASE_PHYSICS_ENTITY_H
#define __BASE_PHYSICS_ENTITY_H

#include "BaseEntity.h"


class CBasePhysicsEntity : public CBaseEntity {
public:
	CBasePhysicsEntity( const std::string& name, const CEntityClass& clazz, int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp, float mass );
	CBasePhysicsEntity( const std::string& name, const CEntityClass& clazz, int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp, float mass, dingus::CCollidableContainer& colContainer );

	unco::CPhysicsComponent const& getPhysComp() const { return *mPhysComp; }
	unco::CPhysicsComponent& getPhysComp() { return *mPhysComp; }

protected:
	void internalAttach();
	
private:
	unco::CPhysicsComponent*	mPhysComp;
	float						mMass;
};


#endif
