#include "../stdafx.h"
#pragma hdrstop

#include "CollidePart.h"
#include <dingus/math/MatrixMisc.h>

CBoxCollidePartDesc::CBoxCollidePartDesc( const SVector3& size, const SVector3& pos, const SQuaternion& rot )
:	mSize(size),
	mPos(pos),
	mRot(rot)
{
}

unco::CAbstractColComponent* CBoxCollidePartDesc::createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const
{
	unco::CColBoxComponent* c = new unco::CColBoxComponent( baseMatrix, &container );
	D3DXMatrixRotationQuaternion( &c->getMatrix(), &mRot );
	c->getMatrix().getOrigin() = mPos + (mSize.y*0.5f) * c->getMatrix().getAxisY();
	c->setSize( mSize );
	return c;
}

void CBoxCollidePartDesc::calcMass( dMass& mass, double density ) const
{
	dMass m;
	dMassSetBox( &m, density, mSize.x, mSize.y, mSize.z );
	dingus::SMatrix4x4 rotm;
	D3DXMatrixRotationQuaternion( &rotm, &mRot );
	dMatrix3 odem;
	dingus::matrixToDoubleTransposed34( rotm, odem );
	dMassRotate( &m, odem );
	dMassTranslate( &m, mPos.x, mPos.y, mPos.z );
	dMassAdd( &mass, &m );
}


CSphereCollidePartDesc::CSphereCollidePartDesc( float size, const SVector3& pos )
:	mSize(size),
	mPos(pos)
{
}

unco::CAbstractColComponent* CSphereCollidePartDesc::createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const
{
	unco::CColSphereComponent* c = new unco::CColSphereComponent( baseMatrix, &container );
	c->getMatrix().getOrigin() = mPos;
	c->setRadius( mSize );
	return c;
}

void CSphereCollidePartDesc::calcMass( dMass& mass, double density ) const
{
	dMass m;
	dMassSetSphere( &m, density, mSize );
	dMassTranslate( &m, mPos.x, mPos.y, mPos.z );
	dMassAdd( &mass, &m );
}


CMeshCollidePartDesc::CMeshCollidePartDesc( dingus::CCollisionMesh& mesh, const SVector3& pos, const SQuaternion& rot )
:	mMesh(&mesh),
	mPos(pos),
	mRot(rot)
{
}

unco::CAbstractColComponent* CMeshCollidePartDesc::createColComp( const SMatrix4x4& baseMatrix, dingus::CCollidableContainer& container, bool flipCull ) const
{
	unco::CColMeshComponent* c = new unco::CColMeshComponent( *mMesh, flipCull, baseMatrix, &container );
	D3DXMatrixRotationQuaternion( &c->getMatrix(), &mRot );
	c->getMatrix().getOrigin() = mPos;
	return c;
}

void CMeshCollidePartDesc::calcMass( dMass& mass, double density ) const
{
	// TBD
	dMass m;
	dMassSetSphere( &m, density, 1.0f );
	dMassTranslate( &m, mPos.x, mPos.y, mPos.z );
	dMassAdd( &mass, &m );
}
